/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.memory;

import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4877;
import net.minecraft.class_634;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.ChestTracker;
import red.jackf.chesttracker.GsonHandler;
import red.jackf.chesttracker.memory.LightweightStack;
import red.jackf.chesttracker.memory.Memory;
import red.jackf.chesttracker.memory.MemoryUtils;
import red.jackf.chesttracker.mixins.AccessorMinecraftServer;

@Environment(value=EnvType.CLIENT)
public class MemoryDatabase {
    private static final class_2487 FULL_DURABILITY_TAG = new class_2487();
    @Nullable
    private static MemoryDatabase currentDatabase = null;
    private final transient String id;
    private ConcurrentMap<class_2960, ConcurrentMap<class_2338, Memory>> locations = new ConcurrentHashMap<class_2960, ConcurrentMap<class_2338, Memory>>();
    private transient ConcurrentMap<class_2960, ConcurrentMap<class_2338, Memory>> namedLocations = new ConcurrentHashMap<class_2960, ConcurrentMap<class_2338, Memory>>();

    private MemoryDatabase(String id) {
        this.id = id;
    }

    public static void clearCurrent() {
        if (currentDatabase != null) {
            currentDatabase.save();
            currentDatabase = null;
        }
    }

    @Nullable
    public static MemoryDatabase getCurrent() {
        String id = MemoryDatabase.getUsableId();
        if (id == null) {
            return null;
        }
        if (currentDatabase != null && currentDatabase.getId().equals(id)) {
            return currentDatabase;
        }
        MemoryDatabase database = new MemoryDatabase(id);
        database.load();
        currentDatabase = database;
        ChestTracker.LOGGER.info("Loaded " + id);
        return database;
    }

    @Nullable
    private static String getUsableId() {
        class_310 mc = class_310.method_1551();
        String id = null;
        class_634 cpnh = mc.method_1562();
        if (cpnh != null && cpnh.method_2872() != null && cpnh.method_2872().method_10758()) {
            if (mc.method_1576() != null) {
                id = "singleplayer-" + MemoryUtils.getSingleplayerName(((AccessorMinecraftServer)mc.method_1576()).getSession());
            } else if (mc.method_1589()) {
                class_4877 server = MemoryUtils.getLastRealmsServer();
                if (server == null) {
                    return null;
                }
                id = "realms-" + MemoryUtils.makeFileSafe(server.field_22604 + "-" + server.method_25062());
            } else if (mc.method_1576() == null && mc.method_1558() != null) {
                id = (mc.method_1558().method_2994() ? "lan-" : "multiplayer-") + MemoryUtils.makeFileSafe(mc.method_1558().field_3761);
            }
        }
        return id;
    }

    public Set<class_2960> getDimensions() {
        return this.locations.keySet();
    }

    public String getId() {
        return this.id;
    }

    public void save() {
        Path savePath = this.getFilePath();
        try {
            try {
                Files.createDirectory(savePath.getParent(), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            FileWriter writer = new FileWriter(savePath.toString());
            GsonHandler.get().toJson(this.locations, (Appendable)writer);
            writer.flush();
            writer.close();
            ChestTracker.LOGGER.info("Saved data for " + this.id);
        }
        catch (Exception ex) {
            ChestTracker.LOGGER.error("Error saving file for " + this.id);
            ChestTracker.LOGGER.error((Object)ex);
        }
    }

    public void load() {
        Path loadPath = this.getFilePath();
        try {
            if (Files.exists(loadPath, new LinkOption[0])) {
                ChestTracker.LOGGER.info("Found data for " + this.id);
                FileReader reader = new FileReader(loadPath.toString());
                Map raw = (Map)GsonHandler.get().fromJson(new JsonReader((Reader)reader), new TypeToken<Map<class_2960, Map<class_2338, Memory>>>(){}.getType());
                if (raw == null) {
                    ChestTracker.LOGGER.info("Empty file found for " + this.id);
                    this.locations = new ConcurrentHashMap<class_2960, ConcurrentMap<class_2338, Memory>>();
                    this.namedLocations = new ConcurrentHashMap<class_2960, ConcurrentMap<class_2338, Memory>>();
                } else {
                    this.locations = new ConcurrentHashMap<class_2960, ConcurrentMap<class_2338, Memory>>();
                    for (Map.Entry entry : raw.entrySet()) {
                        this.locations.put((class_2960)entry.getKey(), new ConcurrentHashMap((Map)entry.getValue()));
                    }
                    this.generateNamedLocations();
                }
            } else {
                ChestTracker.LOGGER.info("No data found for " + this.id);
                this.locations = new ConcurrentHashMap<class_2960, ConcurrentMap<class_2338, Memory>>();
                this.namedLocations = new ConcurrentHashMap<class_2960, ConcurrentMap<class_2338, Memory>>();
            }
        }
        catch (Exception ex) {
            ChestTracker.LOGGER.error("Error reading file for " + this.id);
            ChestTracker.LOGGER.error((Object)ex);
        }
    }

    private void generateNamedLocations() {
        ConcurrentHashMap<class_2960, ConcurrentMap<class_2338, Memory>> namedLocations = new ConcurrentHashMap<class_2960, ConcurrentMap<class_2338, Memory>>();
        for (class_2960 worldId : this.locations.keySet()) {
            ConcurrentMap newMap = namedLocations.computeIfAbsent(worldId, id -> new ConcurrentHashMap());
            ((ConcurrentMap)this.locations.get(worldId)).forEach((pos, memory) -> {
                if (memory.getTitle() != null) {
                    newMap.put(pos, memory);
                }
            });
        }
        this.namedLocations = namedLocations;
    }

    @NotNull
    public Path getFilePath() {
        return FabricLoader.getInstance().getGameDir().resolve("chesttracker").resolve(this.id + ".json");
    }

    public boolean positionExists(class_2960 worldId, class_2338 pos) {
        return this.locations.containsKey(worldId) && ((ConcurrentMap)this.locations.get(worldId)).containsKey(pos);
    }

    public List<class_1799> getItems(class_2960 worldId) {
        if (this.locations.containsKey(worldId)) {
            HashMap<LightweightStack, Integer> count = new HashMap<LightweightStack, Integer>();
            Map location = (Map)this.locations.get(worldId);
            location.forEach((pos, memory) -> memory.getItems().forEach(stack -> {
                LightweightStack lightweightStack = new LightweightStack(stack.method_7909(), stack.method_7969());
                count.merge(lightweightStack, stack.method_7947(), Integer::sum);
            }));
            ArrayList<class_1799> results = new ArrayList<class_1799>();
            count.forEach((lightweightStack, integer) -> {
                class_1799 stack = new class_1799((class_1935)lightweightStack.getItem(), integer.intValue());
                stack.method_7980(lightweightStack.getTag());
                results.add(stack);
            });
            return results;
        }
        return Collections.emptyList();
    }

    public Collection<Memory> getAllMemories(class_2960 worldId) {
        if (this.locations.containsKey(worldId)) {
            return ((ConcurrentMap)this.locations.get(worldId)).values();
        }
        return Collections.emptyList();
    }

    public Collection<Memory> getNamedMemories(class_2960 worldId) {
        if (this.namedLocations.containsKey(worldId)) {
            return ((ConcurrentMap)this.namedLocations.get(worldId)).values();
        }
        return Collections.emptyList();
    }

    public void mergeItems(class_2960 worldId, Memory memory, Collection<class_2338> toRemove) {
        if (!ChestTracker.CONFIG.miscOptions.rememberNewChests && !MemoryUtils.shouldForceNextMerge()) {
            if (this.locations.containsKey(worldId)) {
                boolean exists = false;
                for (Memory existingMemory : ((ConcurrentMap)this.locations.get(worldId)).values()) {
                    if (!Objects.equals(existingMemory.getPosition(), memory.getPosition())) continue;
                    exists = true;
                    break;
                }
                if (!exists) {
                    return;
                }
            } else {
                return;
            }
        }
        MemoryUtils.setForceNextMerge(false);
        if (this.locations.containsKey(worldId)) {
            ConcurrentMap map = (ConcurrentMap)this.locations.get(worldId);
            map.remove(memory.getPosition());
            toRemove.forEach(map::remove);
        }
        if (this.namedLocations.containsKey(worldId)) {
            ConcurrentMap map = (ConcurrentMap)this.namedLocations.get(worldId);
            map.remove(memory.getPosition());
            toRemove.forEach(map::remove);
        }
        this.mergeItems(worldId, memory);
    }

    public void mergeItems(class_2960 worldId, Memory memory) {
        if (memory.getItems().size() > 0 || memory.getTitle() != null || !ChestTracker.CONFIG.miscOptions.rememberNewChests) {
            this.addItem(worldId, memory, this.locations);
            if (memory.getTitle() != null) {
                this.addItem(worldId, memory, this.namedLocations);
            }
        }
    }

    private void addItem(class_2960 worldId, Memory memory, ConcurrentMap<class_2960, ConcurrentMap<class_2338, Memory>> map) {
        ConcurrentMap memoryMap = map.computeIfAbsent(worldId, identifier -> new ConcurrentHashMap());
        memoryMap.put(memory.getPosition(), memory);
    }

    public void removePos(class_2960 worldId, class_2338 pos) {
        Map namedLocation;
        Map location = (Map)this.locations.get(worldId);
        if (location != null) {
            location.remove(pos);
        }
        if ((namedLocation = (Map)this.namedLocations.get(worldId)) != null) {
            namedLocation.remove(pos);
        }
    }

    public List<Memory> findItems(class_1799 toFind, class_2960 worldId) {
        ArrayList<Memory> found = new ArrayList<Memory>();
        Map location = (Map)this.locations.get(worldId);
        class_746 playerEntity = class_310.method_1551().field_1724;
        if (location != null && playerEntity != null) {
            for (Map.Entry entry : location.entrySet()) {
                if (entry.getKey() == null || !((Memory)entry.getValue()).getItems().stream().anyMatch(candidate -> MemoryUtils.areStacksEquivalent(toFind, candidate, toFind.method_7969() == null || toFind.method_7969().equals((Object)FULL_DURABILITY_TAG)))) continue;
                if (MemoryUtils.checkExistsInWorld((Memory)entry.getValue())) {
                    if (((Memory)entry.getValue()).getPosition() != null && ChestTracker.getSquareSearchRange() != Integer.MAX_VALUE && !(((Memory)entry.getValue()).getPosition().method_10262((class_2382)playerEntity.method_24515()) <= (double)ChestTracker.getSquareSearchRange())) continue;
                    found.add((Memory)entry.getValue());
                    continue;
                }
                MemoryDatabase database = MemoryDatabase.getCurrent();
                if (database == null) continue;
                database.removePos(worldId, (class_2338)entry.getKey());
            }
        }
        return found;
    }

    public void clearDimension(class_2960 currentWorldId) {
        this.locations.remove(currentWorldId);
        this.namedLocations.remove(currentWorldId);
    }

    static {
        FULL_DURABILITY_TAG.method_10569("Damage", 0);
    }
}

