/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2812;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_3908;
import net.minecraft.class_3954;
import net.minecraft.class_465;
import net.minecraft.class_485;
import net.minecraft.class_4877;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.ChestTracker;
import red.jackf.chesttracker.compat.AppliedEnergisticsHandler;
import red.jackf.chesttracker.compat.ExpandedStorageHandler;
import red.jackf.chesttracker.memory.Memory;
import red.jackf.chesttracker.memory.MemoryDatabase;

@Environment(value=EnvType.CLIENT)
public abstract class MemoryUtils {
    public static final class_2960 ENDER_CHEST_ID = ChestTracker.id("ender_chest");
    @Nullable
    private static class_2338 latestPos = null;
    @Nullable
    private static class_4877 lastRealmsServer = null;
    private static List<Memory> currentlyCheckedMemories = new ArrayList<Memory>();
    private static int currentlyCheckedIndex = 0;
    private static class_2960 currentlyCheckedWorldId = null;
    private static boolean ignoreNextMerge = false;
    private static boolean forceNextMerge = false;
    private static boolean wasEnderchest;
    private static boolean expandedStorageFailed;

    public static <T extends class_1703> void handleItemsFromScreen(@NotNull class_465<T> screen) {
        if (!ignoreNextMerge) {
            if (MemoryUtils.validScreenToTrack(screen)) {
                class_310 mc = class_310.method_1551();
                MemoryDatabase database = MemoryDatabase.getCurrent();
                if (database != null && mc.field_1687 != null && latestPos != null) {
                    List<class_1799> stacks = MemoryUtils.condenseItems(screen.method_17577().field_7761.stream().filter(MemoryUtils::isValidSlot).map(class_1735::method_7677).collect(Collectors.toList()));
                    class_2680 state = mc.field_1687.method_8320(latestPos);
                    if (state.method_26204() == class_2246.field_10443) {
                        database.mergeItems(ENDER_CHEST_ID, Memory.of(class_2338.field_10980, stacks, null, null), Collections.emptyList());
                    } else {
                        class_2561 title = MemoryUtils.getTitleFromScreen(screen, mc.field_1687.method_8321(latestPos));
                        Collection<class_2338> connected = MemoryUtils.getConnected((class_1937)mc.field_1687, latestPos);
                        database.mergeItems(mc.field_1687.method_27983().method_29177(), Memory.of(latestPos, stacks, title, connected.size() > 0 ? MemoryUtils.getAveragePos(latestPos, connected) : null), connected);
                    }
                }
                if (ChestTracker.CONFIG.miscOptions.printGuiClassNames) {
                    ChestTracker.sendDebugMessage((class_2561)new class_2585(screen.getClass().getSimpleName()));
                }
            }
        } else {
            ignoreNextMerge = false;
        }
    }

    public static void ignoreNextMerge() {
        ignoreNextMerge = true;
    }

    public static void setForceNextMerge(boolean forceNextMerge) {
        MemoryUtils.forceNextMerge = forceNextMerge;
    }

    public static boolean shouldForceNextMerge() {
        return forceNextMerge;
    }

    private static boolean isValidSlot(class_1735 slot) {
        try {
            return !(slot.field_7871 instanceof class_1661) && !AppliedEnergisticsHandler.isAE2Slot(slot) && slot.method_7681();
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static List<class_1799> condenseItems(List<class_1799> list) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        list.forEach(newStack -> {
            boolean exists = false;
            for (class_1799 oldStack : stacks) {
                if (!MemoryUtils.areStacksEquivalent(newStack, oldStack, false)) continue;
                oldStack.method_7939(oldStack.method_7947() + newStack.method_7947());
                exists = true;
            }
            if (!exists) {
                stacks.add((class_1799)newStack);
            }
        });
        return stacks;
    }

    private static class_243 getAveragePos(class_2338 basePos, Collection<class_2338> connected) {
        class_243 base = class_243.method_24954((class_2382)basePos);
        for (class_2338 pos : connected) {
            base = base.method_1019(class_243.method_24954((class_2382)pos));
        }
        return base.method_1021((double)(1.0f / (float)(1 + connected.size()))).method_1020(class_243.method_24954((class_2382)basePos));
    }

    public static Collection<class_2338> getConnected(@NotNull class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        if (state.method_26204() instanceof class_2281) {
            if (state.method_11654((class_2769)class_2281.field_10770) != class_2745.field_12569) {
                boolean left = state.method_11654((class_2769)class_2281.field_10770) == class_2745.field_12574;
                switch ((class_2350)state.method_11654((class_2769)class_2281.field_10768)) {
                    case field_11043: {
                        return Collections.singleton(pos.method_10069(left ? 1 : -1, 0, 0));
                    }
                    case field_11035: {
                        return Collections.singleton(pos.method_10069(left ? -1 : 1, 0, 0));
                    }
                    case field_11039: {
                        return Collections.singleton(pos.method_10069(0, 0, left ? -1 : 1));
                    }
                    case field_11034: {
                        return Collections.singleton(pos.method_10069(0, 0, left ? 1 : -1));
                    }
                }
            }
        } else if (!expandedStorageFailed && FabricLoader.getInstance().isModLoaded("expandedstorage")) {
            try {
                Collection<class_2338> result = ExpandedStorageHandler.check(state, world, pos);
                if (!result.isEmpty()) {
                    return result;
                }
            }
            catch (Error ex) {
                ChestTracker.LOGGER.error("Error loading expanded storage compat", (Throwable)ex);
                expandedStorageFailed = true;
            }
        }
        return Collections.emptyList();
    }

    @Nullable
    private static class_2561 getTitleFromScreen(class_465<?> screen, @Nullable class_2586 blockEntity) {
        class_2561 title = screen.method_25440();
        if (title instanceof class_2588) {
            return null;
        }
        if (blockEntity instanceof class_3908) {
            return title;
        }
        return null;
    }

    private static <T extends class_1703> boolean validScreenToTrack(class_465<T> screen) {
        return !(screen instanceof class_485) && screen != null;
    }

    @Nullable
    public static class_2338 getLatestPos() {
        return latestPos;
    }

    public static void setLatestPos(@Nullable class_2338 latestPos) {
        MemoryUtils.latestPos = latestPos != null ? latestPos.method_10062() : null;
    }

    public static String getSingleplayerName(class_32.class_5143 session) {
        return session.method_27005();
    }

    public static String makeFileSafe(String name) {
        String filteredString = name.replaceAll("(?U)[^\\p{Alnum} _-{}#'@~()]", "_");
        if (filteredString.length() > 180) {
            return filteredString.substring(0, 180);
        }
        return filteredString;
    }

    public static boolean areStacksEquivalent(@NotNull class_1799 stack1, @NotNull class_1799 stack2, boolean ignoreNbt) {
        return stack1.method_7909() == stack2.method_7909() && (ignoreNbt || !stack1.method_7985() && !stack2.method_7985() || Objects.equals(stack1.method_7969(), stack2.method_7969()));
    }

    @Nullable
    public static class_4877 getLastRealmsServer() {
        return lastRealmsServer;
    }

    public static void setLastRealmsServer(@Nullable class_4877 lastRealmsServer) {
        MemoryUtils.lastRealmsServer = lastRealmsServer;
    }

    public static boolean checkExistsInWorld(Memory memory) {
        return MemoryUtils.checkExistsInWorld(memory, class_310.method_1551().field_1687);
    }

    public static boolean checkExistsInWorld(Memory memory, class_638 world) {
        class_2338 pos = memory.getPosition();
        if (world != null && pos != null) {
            class_2818 chunk = world.method_8500(pos);
            return chunk instanceof class_2812 || MemoryUtils.isValidInventoryHolder(chunk.method_8320(pos).method_26204(), (class_1937)world, pos);
        }
        return true;
    }

    public static boolean isValidInventoryHolder(class_2248 block, class_1937 world, class_2338 pos) {
        return block instanceof class_2343 || block instanceof class_3954;
    }

    public static void checkValidCycle(class_638 world) {
        MemoryDatabase database;
        if (world.method_8510() % (long)ChestTracker.CONFIG.databaseOptions.destroyedMemoryCheckInterval == 0L && (database = MemoryDatabase.getCurrent()) != null) {
            if (!world.method_27983().method_29177().equals((Object)currentlyCheckedWorldId)) {
                currentlyCheckedWorldId = world.method_27983().method_29177();
                currentlyCheckedMemories.clear();
                currentlyCheckedIndex = 0;
            }
            if (currentlyCheckedMemories.size() == 0) {
                currentlyCheckedMemories = new ArrayList<Memory>();
                for (Memory memory : database.getAllMemories(world.method_27983().method_29177())) {
                    currentlyCheckedMemories.add(memory);
                }
                currentlyCheckedIndex = currentlyCheckedMemories.size() - 1;
            }
            if (currentlyCheckedIndex >= 0) {
                Memory memory = currentlyCheckedMemories.get(currentlyCheckedIndex);
                if (memory != null) {
                    if (!MemoryUtils.checkExistsInWorld(memory, world)) {
                        database.removePos(world.method_27983().method_29177(), memory.getPosition());
                    }
                    if (ChestTracker.CONFIG.miscOptions.rememberNewChests && memory.getTitle() == null && memory.getItems().size() == 0) {
                        database.removePos(world.method_27983().method_29177(), memory.getPosition());
                    }
                }
                currentlyCheckedMemories.remove(currentlyCheckedIndex);
                --currentlyCheckedIndex;
            }
        }
    }

    public static void setWasEnderchest(boolean wasEnderchest) {
        MemoryUtils.wasEnderchest = wasEnderchest;
    }

    public static boolean wasLastEnderchest() {
        return wasEnderchest;
    }

    static {
        expandedStorageFailed = false;
    }
}

