/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.resource;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import red.jackf.chesttracker.ChestTracker;
import red.jackf.chesttracker.GsonHandler;

@Environment(value=EnvType.CLIENT)
public class ButtonPositionManager
extends class_4309
implements IdentifiableResourceReloadListener {
    private static ImmutableMap<String, ButtonPosition> overrides = ImmutableMap.of();

    public ButtonPositionManager() {
        super(GsonHandler.get(), "button_positions");
    }

    public static ImmutableMap<String, ButtonPosition> getOverrides() {
        return overrides;
    }

    protected void apply(Map<class_2960, JsonElement> loader, class_3300 manager, class_3695 profiler) {
        HashMap overrides = new HashMap();
        for (Map.Entry<class_2960, JsonElement> entry : loader.entrySet()) {
            try {
                ButtonPosition position = (ButtonPosition)GsonHandler.get().fromJson(entry.getValue(), ButtonPosition.class);
                position.classNames.forEach(s -> overrides.put(s, position));
            }
            catch (JsonSyntaxException e) {
                ChestTracker.LOGGER.error("Parsing error loading button position override {}", (Object)entry.getKey(), (Object)e);
            }
        }
        ButtonPositionManager.overrides = ImmutableMap.copyOf(overrides);
    }

    public class_2960 getFabricId() {
        return ChestTracker.id("button_positions");
    }

    public static class ButtonPosition {
        public List<String> classNames = new ArrayList<String>();
        public HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
        public int horizontalOffset = 0;
        public VerticalAlignment verticalAlignment = VerticalAlignment.TOP;
        public int verticalOffset = 0;

        public String toString() {
            return "ButtonPosition{classNames=" + this.classNames + ", horizontalAlignment=" + this.horizontalAlignment + ", horizontalOffset=" + this.horizontalOffset + ", verticalAlignment=" + this.verticalAlignment + ", verticalOffset=" + this.verticalOffset + "}";
        }
    }

    public static enum VerticalAlignment {
        TOP,
        BOTTOM;

    }

    public static enum HorizontalAlignment {
        LEFT,
        RIGHT;

    }
}

