/*
 * Decompiled with CFR 0.152.
 */
package io.github.kabanfriends.craftgr;

import io.github.kabanfriends.craftgr.config.GRConfig;
import io.github.kabanfriends.craftgr.handler.OverlayHandler;
import io.github.kabanfriends.craftgr.handler.SongHandler;
import io.github.kabanfriends.craftgr.platform.Platform;
import io.github.kabanfriends.craftgr.render.impl.SongInfoOverlay;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.minecraft.client.Minecraft;
import okhttp3.OkHttpClient;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CraftGR {
    public static Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "craftgr";
    public static final String MOD_NAME = "CraftGR";
    public static final Minecraft MC = Minecraft.m_91087_();
    public static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private static Platform platform;
    private static OkHttpClient httpClient;

    public static void init(Platform platform) {
        AutoConfig.register(GRConfig.class, GsonConfigSerializer::new);
        CraftGR.platform = platform;
        httpClient = new OkHttpClient.Builder().connectTimeout(20L, TimeUnit.SECONDS).writeTimeout(40L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).build();
        OverlayHandler.addOverlay(new SongInfoOverlay());
        SongHandler.getInstance().initialize();
    }

    public static Platform getPlatform() {
        return platform;
    }

    public static OkHttpClient getHttpClient() {
        return httpClient;
    }

    public static void log(Level level, String message) {
        LOGGER.log(level, "[CraftGR] " + message);
    }
}

