/*
 * Decompiled with CFR 0.152.
 */
package io.github.kabanfriends.craftgr.audio;

import io.github.kabanfriends.craftgr.CraftGR;
import io.github.kabanfriends.craftgr.config.GRConfig;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.SampleBuffer;
import net.minecraft.sounds.SoundSource;
import org.apache.logging.log4j.Level;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;

public class AudioPlayer {
    private InputStream stream;
    private Bitstream bitstream;
    private Decoder decoder;
    private IntBuffer buffer;
    private IntBuffer source;
    private float volume = 0.0f;
    private boolean playing = false;

    public AudioPlayer(InputStream stream) {
        this.stream = stream;
        this.bitstream = new Bitstream(stream);
        this.decoder = new Decoder();
    }

    protected int alError() {
        int error = AL10.alGetError();
        if (error != 0) {
            CraftGR.log(Level.ERROR, String.format("AL10 Error: %d: %s", error, AL10.alGetString((int)error)));
            return error;
        }
        return 0;
    }

    public ProcessResult play() {
        try {
            this.source = BufferUtils.createIntBuffer((int)1);
            AL10.alGenSources((IntBuffer)this.source);
            int error = this.alError();
            if (error != 0) {
                this.close();
                if (error == 40964) {
                    return ProcessResult.AL_ENGINE_STOP;
                }
                return ProcessResult.AL_ERROR;
            }
            AL10.alSourcei((int)this.source.get(0), (int)4103, (int)0);
            AL10.alSourcef((int)this.source.get(0), (int)4099, (float)1.0f);
            AL10.alSourcef((int)this.source.get(0), (int)4106, (float)(this.volume * ((float)GRConfig.getConfig().volume / 100.0f) * CraftGR.MC.f_91066_.m_92147_(SoundSource.MASTER)));
            error = this.alError();
            if (error != 0) {
                this.close();
                if (error == 40964) {
                    return ProcessResult.AL_ENGINE_STOP;
                }
                return ProcessResult.AL_ERROR;
            }
            this.playing = true;
            ProcessResult result = ProcessResult.SUCCESS;
            while (this.playing && result == ProcessResult.SUCCESS) {
                AL10.alSourcef((int)this.source.get(0), (int)4106, (float)(this.volume * ((float)GRConfig.getConfig().volume / 100.0f) * CraftGR.MC.f_91066_.m_92147_(SoundSource.MASTER)));
                result = this.decodeFrame();
            }
            this.close();
            return result;
        }
        catch (Exception e) {
            if (this.playing) {
                e.printStackTrace();
                return ProcessResult.EXCEPTION;
            }
            return ProcessResult.STOP;
        }
    }

    public void close() throws BitstreamException {
        if (this.source != null) {
            AL10.alSourceStop((int)this.source.get());
            AL10.alDeleteSources((IntBuffer)this.source);
            this.source = null;
        }
        if (this.buffer != null) {
            AL10.alDeleteBuffers((IntBuffer)this.buffer);
            this.buffer = null;
        }
    }

    protected ProcessResult decodeFrame() {
        try {
            Header h = this.bitstream.readFrame();
            if (h == null) {
                this.close();
                return ProcessResult.STOP;
            }
            SampleBuffer output = (SampleBuffer)this.decoder.decodeFrame(h, this.bitstream);
            short[] samples = output.getBuffer();
            if (this.buffer == null) {
                this.buffer = BufferUtils.createIntBuffer((int)1);
            } else {
                int processed = AL10.alGetSourcei((int)this.source.get(0), (int)4118);
                if (processed > 0) {
                    AL10.alSourceUnqueueBuffers((int)this.source.get(0), (IntBuffer)this.buffer);
                }
            }
            AL10.alGenBuffers((IntBuffer)this.buffer);
            ShortBuffer shortBuffer = BufferUtils.createShortBuffer((int)output.getBufferLength()).put(samples, 0, output.getBufferLength());
            ShortBuffer data = (ShortBuffer)((Buffer)shortBuffer).flip();
            AL10.alBufferData((int)this.buffer.get(0), (int)(output.getChannelCount() > 1 ? 4355 : 4353), (ShortBuffer)data, (int)output.getSampleFrequency());
            AL10.alSourceQueueBuffers((int)this.source.get(0), (IntBuffer)this.buffer);
            int state = AL10.alGetSourcei((int)this.source.get(0), (int)4112);
            if (this.playing && state != 4114) {
                AL10.alSourcePlay((int)this.source.get(0));
            }
            this.bitstream.closeFrame();
            return ProcessResult.SUCCESS;
        }
        catch (Exception e) {
            if (this.playing) {
                e.printStackTrace();
                return ProcessResult.EXCEPTION;
            }
            return ProcessResult.STOP;
        }
    }

    protected boolean skipFrame() throws JavaLayerException {
        Header h = this.bitstream.readFrame();
        if (h == null) {
            return false;
        }
        this.bitstream.closeFrame();
        return true;
    }

    public void stop() {
        this.playing = false;
        if (this.source != null) {
            AL10.alSourcef((int)this.source.get(0), (int)4106, (float)0.0f);
            AL10.alSourceStop((int)this.source.get());
        }
    }

    public void setVolume(float f) {
        this.volume = f;
        if (this.playing && this.source != null) {
            float volume = f * ((float)GRConfig.getConfig().volume / 100.0f) * CraftGR.MC.f_91066_.m_92147_(SoundSource.MASTER);
            AL10.alSourcef((int)this.source.get(0), (int)4106, (float)volume);
        }
    }

    public float getVolume() {
        return this.volume;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public static enum ProcessResult {
        SUCCESS,
        STOP,
        AL_ERROR,
        AL_ENGINE_STOP,
        EXCEPTION;

    }
}

