/*
 * Decompiled with CFR 0.152.
 */
package io.github.kabanfriends.craftgr.handler;

import io.github.kabanfriends.craftgr.CraftGR;
import io.github.kabanfriends.craftgr.audio.AudioPlayer;
import io.github.kabanfriends.craftgr.config.GRConfig;
import io.github.kabanfriends.craftgr.util.InitState;
import java.io.InputStream;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.logging.log4j.Level;

public class AudioPlayerHandler {
    private static final AudioPlayerHandler INSTANCE = new AudioPlayerHandler();
    private InitState initState = InitState.NOT_INITIALIZED;
    private AudioPlayer player;
    private Response response;
    private boolean playing = false;

    public void startPlayback() {
        this.playing = true;
        CraftGR.EXECUTOR.submit(() -> {
            while (this.initState == InitState.SUCCESS) {
                AudioPlayer.ProcessResult result = this.player.play();
                if (result == AudioPlayer.ProcessResult.AL_ERROR || result == AudioPlayer.ProcessResult.EXCEPTION) {
                    CraftGR.log(Level.ERROR, "Error during audio playback! Restarting in 5 seconds...");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    if (result == AudioPlayer.ProcessResult.AL_ENGINE_STOP) {
                        CraftGR.log(Level.INFO, "Sound Engine is unavailable! Playback stopped.");
                        this.stopPlayback(true);
                        return;
                    }
                    if (result == AudioPlayer.ProcessResult.STOP) {
                        CraftGR.log(Level.INFO, "Audio playback has stopped!");
                        return;
                    }
                }
                this.response.close();
                this.initialize();
            }
            CraftGR.log(Level.ERROR, "Cannot start audio playback due to an initialization failure! Fix your config and restart the game.");
            this.stopPlayback();
        });
    }

    public void stopPlayback() {
        this.stopPlayback(false);
    }

    public void stopPlayback(boolean reloading) {
        CraftGR.log(Level.INFO, "Stopping audio playback...");
        if (this.player != null) {
            this.player.stop();
        }
        if (this.response != null) {
            this.response.close();
        }
        this.playing = false;
        this.player = null;
        this.initState = reloading ? InitState.RELOADING : InitState.NOT_INITIALIZED;
    }

    public void initialize() {
        CraftGR.log(Level.INFO, "Initializing the audio player...");
        this.initState = InitState.INITIALIZING;
        try {
            if (this.response != null) {
                this.response.close();
            }
            Request request = new Request.Builder().url(GRConfig.getConfig().url.streamURL).build();
            this.response = CraftGR.getHttpClient().newCall(request).execute();
            InputStream stream = this.response.body().byteStream();
            AudioPlayer audioPlayer = new AudioPlayer(stream);
            if (this.player != null) {
                this.player.stop();
            }
            this.player = audioPlayer;
            this.initState = InitState.SUCCESS;
            CraftGR.log(Level.INFO, "Audio player is ready!");
        }
        catch (Exception err) {
            CraftGR.log(Level.ERROR, "Error when initializing the audio player:");
            err.printStackTrace();
            this.initState = InitState.FAIL;
        }
    }

    public InitState getInitState() {
        return this.initState;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public AudioPlayer getAudioPlayer() {
        return this.player;
    }

    public boolean hasAudioPlayer() {
        return this.player != null;
    }

    public static AudioPlayerHandler getInstance() {
        return INSTANCE;
    }
}

