/*
 * Decompiled with CFR 0.152.
 */
package io.github.kabanfriends.craftgr.handler;

import io.github.kabanfriends.craftgr.CraftGR;
import io.github.kabanfriends.craftgr.config.GRConfig;
import io.github.kabanfriends.craftgr.render.impl.SongInfoOverlay;
import io.github.kabanfriends.craftgr.song.Song;
import io.github.kabanfriends.craftgr.util.InitState;
import io.github.kabanfriends.craftgr.util.TitleFixer;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.logging.log4j.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SongHandler {
    private static final SongHandler INSTANCE = new SongHandler();
    private static InitState initState = InitState.NOT_INITIALIZED;
    private boolean destroyed;
    private Song song;
    private long songStart;
    private long songEnd;

    public void initialize() {
        CraftGR.EXECUTOR.submit(() -> {
            try {
                this.prepareNewSong();
            }
            catch (Exception e) {
                initState = InitState.FAIL;
                return;
            }
            initState = InitState.SUCCESS;
            this.start();
        });
    }

    private void prepareNewSong() {
        this.song = this.getSongFromInfoXML(GRConfig.getConfig().url.songInfoURL);
        SongInfoOverlay.getInstance().createAlbumArtTexture(this.song);
    }

    private void start() {
        if (initState == InitState.SUCCESS) {
            while (!this.destroyed) {
                try {
                    if (this.song != null && System.currentTimeMillis() / 1000L > this.songEnd) {
                        this.prepareNewSong();
                    }
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void destroy() {
        this.destroyed = true;
    }

    private Song getSongFromInfoXML(String url) {
        try {
            String line;
            Request request = new Request.Builder().url(url).build();
            Response response = CraftGR.getHttpClient().newCall(request).execute();
            InputStream stream = response.body().byteStream();
            BufferedReader r = new BufferedReader(new InputStreamReader(stream, Charset.forName("UTF-8")));
            StringBuilder sb = new StringBuilder();
            while ((line = r.readLine()) != null) {
                sb.append(line);
            }
            Document document = SongHandler.loadXMLFromString(sb.toString());
            Element node = document.getDocumentElement();
            Song song = new Song();
            for (Node c1 = node.getFirstChild(); c1 != null; c1 = c1.getNextSibling()) {
                Node c2;
                if (c1.getNodeName().equals("SONGINFO")) {
                    for (c2 = c1.getFirstChild(); c2 != null; c2 = c2.getNextSibling()) {
                        if (c2.getNodeName().equals("TITLE")) {
                            song.title = TitleFixer.fixJapaneseString(c2.getTextContent());
                            continue;
                        }
                        if (c2.getNodeName().equals("ARTIST")) {
                            song.artist = TitleFixer.fixJapaneseString(c2.getTextContent());
                            continue;
                        }
                        if (c2.getNodeName().equals("ALBUM")) {
                            song.album = TitleFixer.fixJapaneseString(c2.getTextContent());
                            continue;
                        }
                        if (c2.getNodeName().equals("YEAR")) {
                            song.year = c2.getTextContent();
                            continue;
                        }
                        if (!c2.getNodeName().equals("CIRCLE")) continue;
                        song.circle = TitleFixer.fixJapaneseString(c2.getTextContent());
                    }
                    continue;
                }
                if (c1.getNodeName().equals("SONGTIMES")) {
                    for (c2 = c1.getFirstChild(); c2 != null; c2 = c2.getNextSibling()) {
                        if (c2.getNodeName().equals("DURATION") && c2.getTextContent().equals("0")) {
                            song.setIntermission(true);
                            continue;
                        }
                        if (c2.getNodeName().equals("SONGSTART")) {
                            song.songStart = Long.parseLong(c2.getTextContent());
                            continue;
                        }
                        if (!c2.getNodeName().equals("SONGEND")) continue;
                        song.songEnd = Long.parseLong(c2.getTextContent());
                    }
                    continue;
                }
                if (c1.getNodeName().equals("SONGDATA")) {
                    for (c2 = c1.getFirstChild(); c2 != null; c2 = c2.getNextSibling()) {
                        if (c2.getNodeName().equals("ALBUMID")) {
                            song.albumId = Integer.parseInt(c2.getTextContent());
                            continue;
                        }
                        if (!c2.getNodeName().equals("RATING")) continue;
                        song.rating = Float.parseFloat(c2.getTextContent());
                    }
                    continue;
                }
                if (!c1.getNodeName().equals("MISC")) continue;
                for (c2 = c1.getFirstChild(); c2 != null; c2 = c2.getNextSibling()) {
                    if (c2.getNodeName().equals("ALBUMART")) {
                        song.albumArt = c2.getTextContent();
                        continue;
                    }
                    if (!c2.getNodeName().equals("OFFSETTIME")) continue;
                    song.offsetTime = Long.parseLong(c2.getTextContent());
                }
            }
            long played = song.offsetTime - song.songStart;
            long duration = song.songEnd - song.songStart;
            this.songStart = System.currentTimeMillis() / 1000L - played;
            this.songEnd = this.songStart + duration;
            if (song.isIntermission()) {
                song.albumArt = "";
                song.title = "";
                this.songEnd = System.currentTimeMillis() / 1000L + 4L;
            }
            response.close();
            return song;
        }
        catch (Exception e) {
            CraftGR.log(Level.ERROR, "Error while fetching song information!");
            e.printStackTrace();
            return null;
        }
    }

    private static Document loadXMLFromString(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        ReaderInputStream is = new ReaderInputStream((Reader)new StringReader(xml), StandardCharsets.UTF_8);
        return builder.parse((InputStream)is);
    }

    public Song getCurrentSong() {
        return this.song;
    }

    public long getSongStart() {
        return this.songStart;
    }

    public long getSongEnd() {
        return this.songEnd;
    }

    public static SongHandler getInstance() {
        return INSTANCE;
    }
}

