/*
 * Decompiled with CFR 0.152.
 */
package io.github.kabanfriends.craftgr.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.kabanfriends.craftgr.CraftGR;
import io.github.kabanfriends.craftgr.handler.AudioPlayerHandler;
import io.github.kabanfriends.craftgr.util.InitState;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TitleScreen.class})
public class MixinTitleScreen {
    private long musicFadeStart;
    @Shadow
    @Final
    private boolean f_96714_;

    @Inject(method={"removed"}, at={@At(value="HEAD")})
    private void onClose(CallbackInfo info) {
        AudioPlayerHandler handler;
        if (AudioPlayerHandler.getInstance().getInitState() == InitState.SUCCESS && (handler = AudioPlayerHandler.getInstance()).getAudioPlayer().isPlaying()) {
            handler.getAudioPlayer().setVolume(1.0f);
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void render(PoseStack poseStack, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        AudioPlayerHandler handler = AudioPlayerHandler.getInstance();
        if (handler.getInitState() == InitState.NOT_INITIALIZED) {
            CraftGR.EXECUTOR.submit(() -> handler.initialize());
        }
        if (handler.getInitState() == InitState.SUCCESS && this.f_96714_ && handler.hasAudioPlayer()) {
            if (!handler.isPlaying()) {
                handler.getAudioPlayer().setVolume(0.0f);
                handler.startPlayback();
            }
            if (handler.isPlaying()) {
                if (this.musicFadeStart == 0L) {
                    this.musicFadeStart = Util.m_137550_();
                }
                float value = this.f_96714_ ? (float)(Util.m_137550_() - this.musicFadeStart) / 2000.0f : 0.0f;
                handler.getAudioPlayer().setVolume(Mth.m_14036_((float)value, (float)0.0f, (float)1.0f));
            }
        }
    }
}

