/*
 * Decompiled with CFR 0.152.
 */
package io.github.kabanfriends.craftgr.render.impl;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.kabanfriends.craftgr.CraftGR;
import io.github.kabanfriends.craftgr.config.GRConfig;
import io.github.kabanfriends.craftgr.handler.SongHandler;
import io.github.kabanfriends.craftgr.render.Overlay;
import io.github.kabanfriends.craftgr.song.Song;
import io.github.kabanfriends.craftgr.util.RenderUtil;
import java.awt.Color;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import me.shedaniel.clothconfig2.api.ConfigScreen;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.logging.log4j.Level;

public class SongInfoOverlay
extends Overlay {
    private static final float BASE_SCALE = 1.0f;
    private static final int ALBUM_ART_SIZE = 105;
    private static final ResourceLocation ALBUM_ART_PLACEHOLDER = new ResourceLocation("craftgr", "textures/album_placeholder.png");
    private static SongInfoOverlay INSTANCE;
    private Map<String, ResourceLocation> albumArts;

    public SongInfoOverlay() {
        INSTANCE = this;
        this.albumArts = new HashMap<String, ResourceLocation>();
    }

    @Override
    public void render(PoseStack poseStack, int mouseX, int mouseY) {
        Song currentSong;
        OverlayVisibility visibility = GRConfig.getConfig().overlayVisibility;
        if (CraftGR.MC.f_91080_ == null) {
            if (visibility != OverlayVisibility.ALWAYS) {
                return;
            }
        } else {
            if (visibility == OverlayVisibility.NONE) {
                return;
            }
            if (visibility == OverlayVisibility.CHAT && !(CraftGR.MC.f_91080_ instanceof ChatScreen)) {
                return;
            }
        }
        if ((currentSong = SongHandler.getInstance().getCurrentSong()) != null) {
            Font font = CraftGR.MC.f_91062_;
            float scale = GRConfig.getConfig().overlayScale;
            RenderUtil.setZLevelPre(poseStack, 400);
            poseStack.m_85841_(SongInfoOverlay.getUIScale(scale), SongInfoOverlay.getUIScale(scale), SongInfoOverlay.getUIScale(scale));
            int albumArtWidth = GRConfig.getConfig().hideAlbumArt ? -6 : 105;
            float[] size = this.getOverlaySize();
            float width = size[0];
            float height = size[1];
            float[] coord = this.getOverlayCoordinate(GRConfig.getConfig().overlayPosition, width, height);
            int x = (int)coord[0];
            int y = (int)coord[1];
            RenderUtil.fill(poseStack, x, y, (float)x + width, y + 105 + 10 + 10, GRConfig.getConfig().overlayBgColor + -16777216, 0.6f);
            if (this.albumArts.containsKey(currentSong.albumArt) && !GRConfig.getConfig().hideAlbumArt) {
                ResourceLocation albumArt = this.albumArts.get(currentSong.albumArt);
                if (albumArt == null) {
                    RenderUtil.bindTexture(ALBUM_ART_PLACEHOLDER);
                } else {
                    RenderUtil.bindTexture(albumArt);
                }
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + 6), (int)(y + 6), (float)0.0f, (float)0.0f, (int)105, (int)105, (int)105, (int)105);
            }
            poseStack.m_85836_();
            poseStack.m_85841_(2.0f, 2.0f, 2.0f);
            if (currentSong.isIntermission()) {
                GuiComponent.m_93243_((PoseStack)poseStack, (Font)CraftGR.MC.f_91062_, (Component)new TranslatableComponent("text.craftgr.song.intermission"), (int)((x + 12 + 8 + albumArtWidth) / 2), (int)((y + 8) / 2), (int)Color.WHITE.getRGB());
            } else {
                GuiComponent.m_93236_((PoseStack)poseStack, (Font)CraftGR.MC.f_91062_, (String)currentSong.title, (int)((x + 12 + 8 + albumArtWidth) / 2), (int)((y + 8) / 2), (int)Color.WHITE.getRGB());
                GuiComponent.m_93236_((PoseStack)poseStack, (Font)CraftGR.MC.f_91062_, (String)("(" + currentSong.year + ")"), (int)((x + 12 + 10 + albumArtWidth) / 2), (int)((y + 8 + 20) / 2), (int)Color.LIGHT_GRAY.getRGB());
                GuiComponent.m_93236_((PoseStack)poseStack, (Font)CraftGR.MC.f_91062_, (String)currentSong.artist, (int)((x + 12 + 8 + albumArtWidth) / 2), (int)((y + 8 + 7 + 40) / 2), (int)Color.LIGHT_GRAY.getRGB());
                GuiComponent.m_93236_((PoseStack)poseStack, (Font)CraftGR.MC.f_91062_, (String)currentSong.album, (int)((x + 12 + 8 + albumArtWidth) / 2), (int)((y + 8 + 7 + 60) / 2), (int)Color.LIGHT_GRAY.getRGB());
                GuiComponent.m_93236_((PoseStack)poseStack, (Font)CraftGR.MC.f_91062_, (String)currentSong.circle, (int)((x + 12 + 8 + albumArtWidth) / 2), (int)((y + 8 + 7 + 80) / 2), (int)Color.LIGHT_GRAY.getRGB());
            }
            poseStack.m_85849_();
            if (currentSong.isIntermission()) {
                RenderUtil.fill(poseStack, x, y + 105 + 10 + 10, (float)x + width, (float)y + height, GRConfig.getConfig().overlayBgColor + -16777216, 0.6f);
            } else {
                long duration = currentSong.songEnd - currentSong.songStart;
                long played = System.currentTimeMillis() / 1000L - SongHandler.getInstance().getSongStart();
                if (played > duration) {
                    played = duration;
                }
                GuiComponent.m_93236_((PoseStack)poseStack, (Font)CraftGR.MC.f_91062_, (String)SongInfoOverlay.getTimer((int)played), (int)(x + 6), (int)(y + 105 + 10), (int)Color.WHITE.getRGB());
                int timerWidth = font.m_92895_(SongInfoOverlay.getTimer((int)duration));
                GuiComponent.m_93236_((PoseStack)poseStack, (Font)CraftGR.MC.f_91062_, (String)SongInfoOverlay.getTimer((int)duration), (int)(x + (int)width - timerWidth - 6), (int)(y + 105 + 10), (int)Color.WHITE.getRGB());
                RenderUtil.fill(poseStack, x, y + 105 + 10 + 10, (float)x + (float)played / (float)duration * width, (float)y + height, GRConfig.getConfig().overlayBarColor + -16777216, 0.6f);
                RenderUtil.fill(poseStack, (float)x + (float)played / (float)duration * width, y + 105 + 10 + 10, (float)x + width, (float)y + height, GRConfig.getConfig().overlayBgColor + -16777216, 0.6f);
            }
            RenderUtil.setZLevelPost(poseStack);
        }
    }

    @Override
    public boolean onMouseClick(int mouseX, int mouseY) {
        if (CraftGR.MC.f_91080_ instanceof ConfirmLinkScreen) {
            return true;
        }
        if (CraftGR.MC.f_91080_ instanceof LevelLoadingScreen) {
            return true;
        }
        if (CraftGR.MC.f_91080_ instanceof ReceivingLevelScreen) {
            return true;
        }
        if (CraftGR.MC.f_91080_ instanceof ProgressScreen) {
            return true;
        }
        if (CraftGR.MC.f_91080_ instanceof ConnectScreen) {
            return true;
        }
        if (CraftGR.MC.f_91080_ instanceof GenericDirtMessageScreen) {
            return true;
        }
        if (CraftGR.getPlatform().isInModMenu()) {
            return true;
        }
        if ((CraftGR.getPlatform().isModLoaded("cloth-config2") || CraftGR.getPlatform().isModLoaded("cloth-config")) && CraftGR.MC.f_91080_ instanceof ConfigScreen) {
            return true;
        }
        OverlayVisibility visibility = GRConfig.getConfig().overlayVisibility;
        if (visibility == OverlayVisibility.NONE) {
            return true;
        }
        if (visibility == OverlayVisibility.CHAT && !(CraftGR.MC.f_91080_ instanceof ChatScreen)) {
            return true;
        }
        Song currentSong = SongHandler.getInstance().getCurrentSong();
        if (currentSong != null && GRConfig.getConfig().openAlbum) {
            if (currentSong.isIntermission()) {
                return true;
            }
            float scale = GRConfig.getConfig().overlayScale;
            float scaledX = (float)mouseX / SongInfoOverlay.getUIScale(scale);
            float scaledY = (float)mouseY / SongInfoOverlay.getUIScale(scale);
            float[] size = this.getOverlaySize();
            float width = size[0];
            float height = size[1];
            float[] coord = this.getOverlayCoordinate(GRConfig.getConfig().overlayPosition, width, height);
            int x = (int)coord[0];
            int y = (int)coord[1];
            if (scaledX >= (float)x && scaledX <= (float)x + width && scaledY >= (float)y && scaledY <= (float)y + height) {
                String link = "https://gensokyoradio.net/music/album/" + currentSong.albumId;
                Screen oldScreen = CraftGR.MC.f_91080_;
                CraftGR.MC.m_91152_((Screen)new ConfirmLinkScreen(result -> {
                    if (result) {
                        Util.m_137581_().m_137646_(link);
                    }
                    CraftGR.MC.m_91152_(oldScreen);
                }, link, true));
                return false;
            }
        }
        return true;
    }

    private float[] getOverlayCoordinate(OverlayPosition position, float width, float height) {
        float offset = 10.0f / GRConfig.getConfig().overlayScale;
        float x = (float)CraftGR.MC.m_91268_().m_85441_() / GRConfig.getConfig().overlayScale - width - offset;
        float y = (float)CraftGR.MC.m_91268_().m_85442_() / GRConfig.getConfig().overlayScale - height - offset;
        switch (position) {
            case TOP_RIGHT: {
                return new float[]{x, offset};
            }
            case BOTTOM_LEFT: {
                return new float[]{offset, y};
            }
            case BOTTOM_RIGHT: {
                return new float[]{x, y};
            }
        }
        return new float[]{offset, offset};
    }

    private float[] getOverlaySize() {
        Song currentSong = SongHandler.getInstance().getCurrentSong();
        Font font = CraftGR.MC.f_91062_;
        int maxWidth = 0;
        if (currentSong.isIntermission()) {
            maxWidth = font.m_92852_((FormattedText)new TranslatableComponent("text.craftgr.song.intermission"));
        } else {
            String[] strings;
            for (String string : strings = new String[]{currentSong.title, currentSong.artist, currentSong.album, currentSong.circle}) {
                int width = font.m_92895_(string);
                if (width <= maxWidth) continue;
                maxWidth = width;
            }
        }
        int albumArtWidth = GRConfig.getConfig().hideAlbumArt ? -6 : 105;
        float width = 19 + albumArtWidth + maxWidth * 2 + 10;
        float height = 131.0f;
        return new float[]{width, height};
    }

    public void createAlbumArtTexture(Song song) {
        if (!this.albumArts.containsKey(song.albumArt)) {
            if (song.albumArt.isEmpty()) {
                this.albumArts.put(song.albumArt, null);
                return;
            }
            CraftGR.EXECUTOR.submit(() -> {
                ResourceLocation albumArt = null;
                try {
                    Request request = new Request.Builder().url(GRConfig.getConfig().url.albumArtURL + song.albumArt).build();
                    Response response = CraftGR.getHttpClient().newCall(request).execute();
                    InputStream stream = response.body().byteStream();
                    while (CraftGR.MC.m_91097_() == null) {
                        Thread.sleep(1L);
                    }
                    albumArt = CraftGR.MC.m_91097_().m_118490_("craftgr_album", new DynamicTexture(NativeImage.m_85058_((InputStream)stream)));
                    this.albumArts.put(song.albumArt, albumArt);
                }
                catch (Exception e) {
                    CraftGR.log(Level.ERROR, "Error while creating album art texture!");
                    e.printStackTrace();
                }
                finally {
                    this.albumArts.put(song.albumArt, albumArt);
                }
            });
        }
    }

    private static String getTimer(int time) {
        int minutes = time / 60;
        int seconds = time % 60;
        return minutes + ":" + (Serializable)(seconds < 10 ? "0" + seconds : Integer.valueOf(seconds));
    }

    private static float getUIScale(float uiScale) {
        double mcScale = CraftGR.MC.m_91268_().m_85449_();
        return (float)(1.0 * (1.0 / mcScale) * (double)uiScale);
    }

    public static SongInfoOverlay getInstance() {
        return INSTANCE;
    }

    public static enum OverlayVisibility {
        NONE,
        ALWAYS,
        MENU,
        CHAT;

    }

    public static enum OverlayPosition {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

