/*
 * Decompiled with CFR 0.152.
 */
package io.github.kabanfriends.craftgr.util;

import java.util.HashMap;

public class TitleFixer {
    private static final HashMap<String, String[]> TABLE = new HashMap();

    public static String fixJapaneseString(String input) {
        input = input.replaceAll("\u3000", "  ");
        input = input.replaceAll("\u200b", "");
        String last = "";
        String current = "";
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            current = input.substring(i, i + 1);
            if (current.equals("\u3099")) {
                line.append(TitleFixer.getFixedChar(last, 0));
                last = "";
                continue;
            }
            if (current.equals("\u309a")) {
                line.append(TitleFixer.getFixedChar(last, 1));
                last = "";
                continue;
            }
            line.append(last);
            last = current;
        }
        line.append(last);
        return line.toString();
    }

    private static String getFixedChar(String base, int type) {
        String[] value;
        if (TABLE.containsKey(base) && (value = TABLE.get(base)).length >= type + 1) {
            return value[type];
        }
        if (type == 0) {
            return base + "\u309b";
        }
        return base + "\u309c";
    }

    static {
        TABLE.put("\u304b", new String[]{"\u304c"});
        TABLE.put("\u304d", new String[]{"\u304e"});
        TABLE.put("\u304f", new String[]{"\u3050"});
        TABLE.put("\u3051", new String[]{"\u3052"});
        TABLE.put("\u3053", new String[]{"\u3054"});
        TABLE.put("\u3055", new String[]{"\u3056"});
        TABLE.put("\u3057", new String[]{"\u3058"});
        TABLE.put("\u3059", new String[]{"\u305a"});
        TABLE.put("\u305b", new String[]{"\u305c"});
        TABLE.put("\u305d", new String[]{"\u305e"});
        TABLE.put("\u305f", new String[]{"\u3060"});
        TABLE.put("\u3061", new String[]{"\u3062"});
        TABLE.put("\u3064", new String[]{"\u3065"});
        TABLE.put("\u3066", new String[]{"\u3067"});
        TABLE.put("\u3068", new String[]{"\u3069"});
        TABLE.put("\u306f", new String[]{"\u3070", "\u3071"});
        TABLE.put("\u3072", new String[]{"\u3073", "\u3074"});
        TABLE.put("\u3075", new String[]{"\u3076", "\u3077"});
        TABLE.put("\u3078", new String[]{"\u3079", "\u307a"});
        TABLE.put("\u307b", new String[]{"\u307c", "\u307d"});
        TABLE.put("\u30ab", new String[]{"\u30ac"});
        TABLE.put("\u30ad", new String[]{"\u30ae"});
        TABLE.put("\u30af", new String[]{"\u30b0"});
        TABLE.put("\u30b1", new String[]{"\u30b2"});
        TABLE.put("\u30b3", new String[]{"\u30b4"});
        TABLE.put("\u30b5", new String[]{"\u30b6"});
        TABLE.put("\u30b7", new String[]{"\u30b8"});
        TABLE.put("\u30b9", new String[]{"\u30ba"});
        TABLE.put("\u30bb", new String[]{"\u30bc"});
        TABLE.put("\u30bd", new String[]{"\u30be"});
        TABLE.put("\u30bf", new String[]{"\u30c0"});
        TABLE.put("\u30c1", new String[]{"\u30c2"});
        TABLE.put("\u30c4", new String[]{"\u30c5"});
        TABLE.put("\u30c6", new String[]{"\u30c7"});
        TABLE.put("\u30c8", new String[]{"\u30c9"});
        TABLE.put("\u30cf", new String[]{"\u30d0", "\u30d1"});
        TABLE.put("\u30d2", new String[]{"\u30d3", "\u30d4"});
        TABLE.put("\u30d5", new String[]{"\u30d6", "\u30d7"});
        TABLE.put("\u30d8", new String[]{"\u30d9", "\u30da"});
        TABLE.put("\u30db", new String[]{"\u30dc", "\u30dd"});
    }
}

