/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.tuffdepth;

import com.traverse.tuffdepth.data.EntityCondition;
import com.traverse.tuffdepth.data.EntityModifier;
import com.traverse.tuffdepth.data.MobDataReloadListener;
import com.traverse.tuffdepth.data.MobManager;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class TuffDepthEvents {
    public static void datapackRegistry(AddReloadListenerEvent evt) {
        evt.addListener((PreparableReloadListener)new MobDataReloadListener());
    }

    public static void onMobSpawned(EntityJoinWorldEvent evt) {
        if (evt.getWorld().m_46472_() == Level.f_46428_ && !evt.getWorld().m_5776_()) {
            TuffDepthEvents.changeEntityStats(evt.getEntity());
        }
    }

    public static void onEntityAttacked(LivingAttackEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            livingEntity = evt.getSource().m_7639_();
            if (livingEntity instanceof Monster) {
                Monster monster = (Monster)livingEntity;
                EntityModifier modifier = MobManager.getInstance().getModifier((Entity)monster);
                for (EntityCondition condition : modifier.getConditions()) {
                    if (condition.getPotionEffect().isEmpty() || !(monster.m_20186_() >= (double)condition.getMinYLevel()) || !(monster.m_20186_() <= (double)condition.getMaxYLevel())) continue;
                    MobEffectInstance effect = new MobEffectInstance(condition.getPotionEffect().get().m_19544_(), condition.getPotionEffect().get().m_19557_(), condition.getPotionEffect().get().m_19564_());
                    player.m_7292_(effect);
                    break;
                }
            }
        }
    }

    private static void changeEntityStats(Entity entity) {
        if (entity instanceof Monster) {
            Monster target = (Monster)entity;
            EntityModifier modifier = MobManager.getInstance().getModifier(entity);
            for (EntityCondition condition : modifier.getConditions()) {
                if (!(target.m_20186_() >= (double)condition.getMinYLevel()) || !(target.m_20186_() <= (double)condition.getMaxYLevel())) continue;
                float targetHealth = (float)(target.m_21172_(Attributes.f_22276_) * condition.getHealthMultiplier());
                target.m_21051_(Attributes.f_22276_).m_22100_((double)targetHealth);
                target.m_21153_(targetHealth);
                float targetDamage = (float)(target.m_21172_(Attributes.f_22281_) * condition.getDamageMultiplier());
                target.m_21051_(Attributes.f_22281_).m_22100_((double)targetDamage);
                break;
            }
        }
    }
}

