/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.tuffdepth.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.traverse.tuffdepth.TuffDepthConfig;
import com.traverse.tuffdepth.data.EntityCondition;
import com.traverse.tuffdepth.data.EntityModifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class MobManager {
    private static final MobManager INSTANCE = new MobManager();
    private static final Codec<MobEffect> MOB_EFFECT_CODEC = ResourceLocation.f_135803_.xmap(arg_0 -> ((IForgeRegistry)ForgeRegistries.MOB_EFFECTS).getValue(arg_0), arg_0 -> ((IForgeRegistry)ForgeRegistries.MOB_EFFECTS).getKey(arg_0));
    private static final Codec<EntityType<?>> ENTITY_TYPE_CODEC = ResourceLocation.f_135803_.xmap(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITIES).getValue(arg_0), arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITIES).getKey(arg_0));
    private static final Codec<MobEffectInstance> MOB_EFFECT_INSTANCE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MOB_EFFECT_CODEC.fieldOf("potion").forGetter(MobEffectInstance::m_19544_), (App)Codec.INT.fieldOf("duration").forGetter(MobEffectInstance::m_19557_), (App)Codec.INT.fieldOf("amplifier").forGetter(MobEffectInstance::m_19564_)).apply((Applicative)instance, MobEffectInstance::new));
    private static final Codec<EntityCondition> CONDITION_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("minYLevel").forGetter(EntityCondition::getMinYLevel), (App)Codec.INT.fieldOf("maxYLevel").forGetter(EntityCondition::getMaxYLevel), (App)Codec.DOUBLE.fieldOf("damageMultiplier").forGetter(EntityCondition::getHealthMultiplier), (App)Codec.DOUBLE.fieldOf("healthMultiplier").forGetter(EntityCondition::getDamageMultiplier), (App)MOB_EFFECT_INSTANCE_CODEC.optionalFieldOf("potionEffect").forGetter(EntityCondition::getPotionEffect)).apply((Applicative)instance, EntityCondition::new));
    public static final Codec<EntityModifier> ENTITY_MODIFIER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ENTITY_TYPE_CODEC.fieldOf("entity").forGetter(EntityModifier::getEntityType), (App)CONDITION_CODEC.listOf().fieldOf("conditions").forGetter(EntityModifier::getConditions)).apply((Applicative)instance, EntityModifier::new));
    private final Map<EntityType<?>, EntityModifier> modifiers = new HashMap();

    public void addModifier(EntityType<?> entityType, EntityModifier modifier) {
        this.modifiers.put(entityType, modifier);
    }

    public EntityModifier getModifier(Entity entity) {
        return this.getModifier(entity.m_6095_());
    }

    public EntityModifier getModifier(EntityType<?> entityType) {
        return this.modifiers.compute(entityType, (type, modifier) -> {
            if (modifier != null) {
                return modifier;
            }
            EntityCondition condition = new EntityCondition((Integer)TuffDepthConfig.general.minYLevel.get(), (Integer)TuffDepthConfig.general.maxYLevel.get(), (Double)TuffDepthConfig.general.damageMultiplier.get(), (Double)TuffDepthConfig.general.healthMultiplier.get(), Optional.empty());
            return new EntityModifier((EntityType<?>)type, List.of(condition));
        });
    }

    public static MobManager getInstance() {
        return INSTANCE;
    }
}

