/*
 * Decompiled with CFR 0.152.
 */
package ml.northwestwind.forgeautofish.config.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ml.northwestwind.forgeautofish.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class FilterSelectionScreen
extends Screen {
    private final Screen parent;
    private EditBox search;
    private final Collection<Item> original = ForgeRegistries.ITEMS.getValues();
    private Collection<Item> searching;
    private final Set<Item> selected = new HashSet<Item>(((List)Config.FILTER.get()).stream().map(string -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(string))).collect(Collectors.toList()));
    private int page;
    private int maxPage = (int)Math.ceil((double)this.original.size() / 300.0);
    private int max = 300;
    private boolean clickProcessed = true;
    private double clickX;
    private double clickY;
    private Button previous;
    private Button next;
    int reducedHeight;
    int reducedWidth;

    public FilterSelectionScreen(Screen parent) {
        super((Component)new TranslatableComponent("gui.filterselection"));
        this.parent = parent;
    }

    protected void m_7856_() {
        this.reducedHeight = this.f_96544_ - 90;
        this.reducedWidth = this.f_96543_ - 30;
        this.max = 300;
        this.maxPage = (int)Math.ceil((double)this.original.size() / (double)this.max);
        this.searching = this.original;
        this.search = new EditBox(this.f_96547_, this.f_96543_ / 2 - 75, 35, 150, 20, (Component)new TranslatableComponent("gui.superfilterscreen.search")){

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (button == 1) {
                    this.m_94144_("");
                }
                return super.m_6375_(mouseX, mouseY, button);
            }
        };
        this.search.m_94151_(s -> {
            String[] args = s.split("/ +/");
            String[] mods = (String[])Arrays.stream(args).filter(s1 -> s1.startsWith("@")).toArray(String[]::new);
            String[] tags = (String[])Arrays.stream(args).filter(s1 -> s1.startsWith("#")).toArray(String[]::new);
            String[] finalArgs = (String[])Arrays.stream(args).filter(s1 -> !s1.startsWith("@") && !s1.startsWith("#")).toArray(String[]::new);
            this.searching = this.original.stream().filter(item -> {
                boolean matchmod = mods.length < 1;
                boolean matchtag = tags.length < 1;
                boolean matcharg = finalArgs.length < 1;
                for (String mod : mods) {
                    mod = mod.toLowerCase().substring(1);
                    matchmod = item.getRegistryName().m_135827_().toLowerCase().contains(mod);
                }
                for (String tag : tags) {
                    String finalTag = tag.toLowerCase().substring(1);
                    matchtag = item.getTags().stream().anyMatch(registryName -> registryName.m_135815_().contains(finalTag));
                }
                for (String arg : finalArgs) {
                    arg = arg.toLowerCase();
                    matcharg = item.getRegistryName().m_135815_().contains(arg) || item.m_41466_().getString().contains(arg);
                }
                return matchmod && matchtag && matcharg;
            }).collect(Collectors.toList());
            this.maxPage = (int)Math.ceil((double)this.searching.size() / (double)this.max);
            if (this.page > this.maxPage - 1) {
                this.page = this.maxPage - 1;
            }
        });
        this.m_142416_((GuiEventListener)this.search);
        Button add = new Button(this.f_96543_ / 2 - 75, 60, 72, 20, (Component)new TranslatableComponent("gui.filterselection.save"), button -> {
            List<String> items = this.selected.stream().map(item -> item.getRegistryName().toString()).collect(Collectors.toList());
            Config.setFILTER(items);
            Minecraft.m_91087_().m_91152_(this.parent);
        });
        this.m_142416_((GuiEventListener)add);
        Button done = new Button(this.f_96543_ / 2 + 3, 60, 72, 20, (Component)new TranslatableComponent("gui.filterselection.cancel"), button -> Minecraft.m_91087_().m_91152_(this.parent));
        this.m_142416_((GuiEventListener)done);
        this.previous = new Button(this.f_96543_ / 2 - 100, 60, 20, 20, (Component)new TextComponent("<"), button -> {
            if (this.page > 0) {
                --this.page;
            }
        });
        this.previous.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.previous);
        this.next = new Button(this.f_96543_ / 2 + 80, 60, 20, 20, (Component)new TextComponent(">"), button -> {
            if (this.page < this.maxPage - 1) {
                ++this.page;
            }
        });
        this.next.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.next);
    }

    public void m_6305_(PoseStack PoseStack2, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(PoseStack2);
        FilterSelectionScreen.m_93215_((PoseStack)PoseStack2, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)-1);
        ArrayList searchingCopy = Lists.newArrayList();
        Collection prioritized = this.searching.stream().filter(item -> {
            boolean pri = ((List)Config.PRIORITIZE.get()).contains(item.getRegistryName().toString());
            if (!pri) {
                searchingCopy.add(item);
            }
            return pri;
        }).collect(Collectors.toList());
        Item[] items = (Item[])Stream.concat(prioritized.stream(), searchingCopy.stream()).toArray(Item[]::new);
        if (items.length > 0 && this.page >= 0) {
            for (int i = this.page * this.max; i < Math.min((this.page + 1) * this.max, this.searching.size()); ++i) {
                Item item2 = items[i];
                int h = i % this.max / (this.max / 30);
                int k = i % this.max % (this.max / 30);
                int x = this.getXPos(h, this.reducedWidth);
                int y = this.getYPos(k, this.reducedHeight);
                ItemStack stack = new ItemStack((ItemLike)item2);
                if (stack.m_41619_()) continue;
                this.f_96542_.m_115123_(stack, x, y);
                if (!this.clickProcessed && this.isMouseInRange(this.clickX, this.clickY, x, y, x + 16, y + 16)) {
                    if (this.selected.contains(item2)) {
                        this.selected.remove(item2);
                    } else {
                        this.selected.add(item2);
                    }
                    this.clickProcessed = true;
                }
                if (this.selected.contains(item2)) {
                    this.m_93179_(PoseStack2, x - 2, y - 2, x + 18, y + 18, Color.GREEN.getRGB(), Color.GREEN.getRGB());
                } else if (this.isMouseInRange(mouseX, mouseY, x, y, x + 16, y + 16)) {
                    this.m_93179_(PoseStack2, x - 2, y - 2, x + 18, y + 18, Color.LIGHT_GRAY.getRGB(), Color.LIGHT_GRAY.getRGB());
                }
                if (!this.isMouseInRange(mouseX, mouseY, x, y, x + 16, y + 16)) continue;
                this.m_6057_(PoseStack2, stack, mouseX, mouseY);
            }
        }
        this.search.m_6305_(PoseStack2, mouseX, mouseY, partialTicks);
        super.m_6305_(PoseStack2, mouseX, mouseY, partialTicks);
    }

    private boolean isMouseInRange(double mouseX, double mouseY, int x1, int y1, int x2, int y2) {
        return mouseX > (double)x1 && mouseX < (double)x2 && mouseY > (double)y1 && mouseY < (double)y2;
    }

    private int getXPos(int h, int width) {
        return width * h / 30 + 15;
    }

    private int getYPos(int k, int height) {
        return height * k / (this.max / 30) + 90;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (!this.search.m_93696_()) {
                Minecraft.m_91087_().m_91152_(this.parent);
            } else {
                this.search.m_94178_(false);
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.clickX = mouseX;
        this.clickY = mouseY;
        this.clickProcessed = false;
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6913_() {
        return false;
    }

    public void m_96624_() {
        this.search.m_94120_();
        super.m_96624_();
        this.previous.f_93624_ = this.page >= 1;
        this.next.f_93624_ = this.page < this.maxPage - 1;
    }

    public boolean m_7043_() {
        return false;
    }
}

