/*
 * Decompiled with CFR 0.152.
 */
package ml.northwestwind.forgeautofish.config.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import ml.northwestwind.forgeautofish.config.Config;
import ml.northwestwind.forgeautofish.config.gui.FilterSelectionScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class SuperFilterScreen
extends Screen {
    private final Screen parent;
    private EditBox search;
    private Collection<Item> original;
    private Collection<Item> searching;
    private int page = 0;
    private int maxPage;
    private int max = 30;
    private Button previous;
    private Button next;
    int reducedHeight;
    int reducedWidth;

    protected SuperFilterScreen(Screen parent) {
        super((Component)new TranslatableComponent("gui.superfilterscreen"));
        this.parent = parent;
    }

    public void m_96624_() {
        this.search.m_94120_();
        this.previous.f_93624_ = this.page >= 1;
        this.next.f_93624_ = this.page < this.maxPage - 1;
    }

    protected void m_7856_() {
        this.reducedHeight = this.f_96544_ - 90;
        this.reducedWidth = this.f_96543_ - 30;
        this.max = 30;
        this.original = ((List)Config.FILTER.get()).stream().map(string -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(string))).collect(Collectors.toList());
        this.maxPage = (int)Math.ceil((double)this.original.size() / (double)this.max);
        this.searching = this.original;
        this.search = new EditBox(this.f_96547_, this.f_96543_ / 2 - 75, 35, 150, 20, (Component)new TranslatableComponent("gui.superfilterscreen.search")){

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (button == 1) {
                    this.m_94144_("");
                }
                return super.m_6375_(mouseX, mouseY, button);
            }
        };
        this.search.m_94151_(s -> {
            String[] args = s.split("/ +/");
            String[] mods = (String[])Arrays.stream(args).filter(s1 -> s1.startsWith("@")).toArray(String[]::new);
            String[] tags = (String[])Arrays.stream(args).filter(s1 -> s1.startsWith("#")).toArray(String[]::new);
            String[] finalArgs = (String[])Arrays.stream(args).filter(s1 -> !s1.startsWith("@") && !s1.startsWith("#")).toArray(String[]::new);
            this.searching = this.original.stream().filter(item -> {
                boolean matchmod = mods.length < 1;
                boolean matchtag = tags.length < 1;
                boolean matcharg = finalArgs.length < 1;
                for (String mod : mods) {
                    mod = mod.toLowerCase().substring(1);
                    matchmod = item.getRegistryName().m_135827_().toLowerCase().contains(mod);
                }
                for (String tag : tags) {
                    String finalTag = tag.toLowerCase().substring(1);
                    matchtag = item.getTags().stream().anyMatch(r -> r.m_135815_().contains(finalTag));
                }
                for (String arg : finalArgs) {
                    arg = arg.toLowerCase();
                    matcharg = item.getRegistryName().m_135815_().contains(arg) || item.m_41466_().getString().contains(arg);
                }
                return matchmod && matchtag && matcharg;
            }).collect(Collectors.toList());
            this.maxPage = (int)Math.ceil((double)this.original.size() / (double)this.max);
            if (this.page > this.maxPage - 1) {
                this.page = this.maxPage - 1;
            }
        });
        this.m_142416_((GuiEventListener)this.search);
        Button add = new Button(this.f_96543_ / 2 - 75, 60, 72, 20, (Component)new TranslatableComponent("gui.superfilterscreen.openfilter"), button -> Minecraft.m_91087_().m_91152_((Screen)new FilterSelectionScreen(this)));
        this.m_142416_((GuiEventListener)add);
        Button done = new Button(this.f_96543_ / 2 + 3, 60, 72, 20, (Component)new TranslatableComponent("gui.superfilterscreen.done"), button -> Minecraft.m_91087_().m_91152_(this.parent));
        this.m_142416_((GuiEventListener)done);
        this.previous = new Button(this.f_96543_ / 2 - 100, 60, 20, 20, (Component)new TextComponent("<"), button -> {
            if (this.page > 0) {
                --this.page;
            }
        });
        this.previous.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.previous);
        this.next = new Button(this.f_96543_ / 2 + 80, 60, 20, 20, (Component)new TextComponent(">"), button -> {
            if (this.page < this.maxPage - 1) {
                ++this.page;
            }
        });
        this.next.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.next);
    }

    public void m_6305_(PoseStack PoseStack2, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(PoseStack2);
        SuperFilterScreen.m_93215_((PoseStack)PoseStack2, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)-1);
        Item[] items = this.searching.toArray(new Item[0]);
        for (int i = this.page * this.max; i < Math.min((this.page + 1) * this.max, this.searching.size()); ++i) {
            Item item = items[i];
            int h = i % this.max / (this.max / 3);
            int k = i % this.max % (this.max / 3);
            ItemStack stack = ItemStack.f_41583_;
            if (item != null) {
                stack = new ItemStack((ItemLike)item);
            }
            if (!stack.m_41619_()) {
                this.f_96542_.m_115123_(stack, this.reducedWidth * h / 3 + 15, this.reducedHeight * k / (this.max / 3) + 90);
            }
            this.f_96547_.m_92883_(PoseStack2, stack.m_41611_().getString(), (float)(this.reducedWidth * h / 3 + 45), (float)(this.reducedHeight * k / (this.max / 3) + 95), Color.WHITE.getRGB());
        }
        this.search.m_6305_(PoseStack2, mouseX, mouseY, partialTicks);
        super.m_6305_(PoseStack2, mouseX, mouseY, partialTicks);
    }

    public boolean m_6913_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            Minecraft.m_91087_().m_91152_(this.parent);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }
}

