/*
 * Decompiled with CFR 0.152.
 */
package ml.northwestwind.forgeautofish.handler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import ml.northwestwind.forgeautofish.AutoFish;
import ml.northwestwind.forgeautofish.config.Config;
import ml.northwestwind.forgeautofish.config.gui.SettingsScreen;
import ml.northwestwind.forgeautofish.keybind.KeyBinds;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="forgeautofish", value={Dist.CLIENT})
public class AutoFishHandler {
    public static boolean autofish = (Boolean)Config.AUTO_FISH.get();
    public static boolean rodprotect = (Boolean)Config.ROD_PROTECT.get();
    public static boolean autoreplace = (Boolean)Config.AUTO_REPLACE.get();
    public static boolean itemfilter = (Boolean)Config.ALL_FILTERS.get();
    public static long recastDelay = (Long)Config.RECAST_DELAY.get();
    public static long reelInDelay = (Long)Config.REEL_IN_DELAY.get();
    private static final List<Item> shouldDrop = Lists.newArrayList();
    private static boolean processingDrop;
    private static boolean pendingReelIn;
    private static boolean pendingRecast;
    private static long tick;

    @SubscribeEvent
    public static void onItemFished(ItemFishedEvent event) {
        if (!itemfilter) {
            return;
        }
        NonNullList stacks = event.getDrops();
        for (ItemStack stack : stacks) {
            if (!((List)Config.FILTER.get()).contains(stack.m_41720_().getRegistryName().toString())) continue;
            shouldDrop.add(stack.m_41720_());
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent e) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (KeyBinds.autofish.m_90859_()) {
            Config.setAutoFish(!autofish);
            if (player != null) {
                player.m_5661_(AutoFishHandler.getText("forgeautofish", autofish), true);
            }
        } else if (KeyBinds.rodprotect.m_90859_()) {
            Config.setRodProtect(!rodprotect);
            if (player != null) {
                player.m_5661_(AutoFishHandler.getText("rodprotect", rodprotect), true);
            }
        } else if (KeyBinds.autoreplace.m_90859_()) {
            Config.setAutoReplace(!autoreplace);
            if (player != null) {
                player.m_5661_(AutoFishHandler.getText("autoreplace", autoreplace), true);
            }
        } else if (KeyBinds.itemfilter.m_90859_()) {
            Config.enableFilter(!itemfilter);
            if (player != null) {
                player.m_5661_(AutoFishHandler.getText("itemfilter", itemfilter), true);
            }
        } else if (KeyBinds.settings.m_90859_()) {
            minecraft.m_91152_((Screen)new SettingsScreen());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.side != LogicalSide.CLIENT || !e.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        Player player = e.player;
        if (!player.m_142081_().equals(Minecraft.m_91087_().f_91074_.m_142081_())) {
            return;
        }
        if (pendingReelIn) {
            if (++tick >= reelInDelay) {
                AutoFishHandler.reelIn(player);
                tick = 0L;
                pendingReelIn = false;
            }
            return;
        }
        if (pendingRecast) {
            if (++tick >= recastDelay) {
                AutoFishHandler.recast(player);
                tick = 0L;
                pendingRecast = false;
            }
            return;
        }
        if (shouldDrop.size() > 0 && !processingDrop) {
            AutoFishHandler.dropItem(player);
            return;
        }
        if (!autofish || processingDrop || player.f_36083_ == null) {
            return;
        }
        Vec3 vector = player.f_36083_.m_20184_();
        double x = vector.m_7096_();
        double y = vector.m_7098_();
        double z = vector.m_7094_();
        if (y < -0.075 && (player.f_36083_.m_20069_() || player.f_36083_.m_20077_()) && x == 0.0 && z == 0.0) {
            pendingReelIn = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void reelIn(Player player) {
        if (!autofish) {
            return;
        }
        InteractionHand hand = AutoFishHandler.findHandOfRod(player);
        if (hand == null) {
            return;
        }
        AutoFishHandler.click(player.f_19853_, player, hand, Minecraft.m_91087_().f_91072_);
        ItemStack fishingRod = player.m_21120_(hand);
        boolean needReplace = false;
        if (fishingRod.m_41776_() - fishingRod.m_41773_() < 2) {
            if (!autoreplace) return;
            needReplace = true;
        } else if (fishingRod.m_41776_() - fishingRod.m_41773_() < 3 && !player.m_7500_() && rodprotect) {
            if (autoreplace) {
                needReplace = true;
            } else {
                autofish = false;
                player.m_5661_(AutoFishHandler.getText("forgeautofish", autofish), true);
                return;
            }
        }
        if (needReplace) {
            AutoFish.LOGGER.info("Fishing rod broke. Finding replacement...");
            boolean found = false;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack;
                if (i == player.m_150109_().f_35977_ || !((stack = player.m_150109_().m_8020_(i)).m_41720_() instanceof FishingRodItem) || rodprotect && stack.m_41776_() - stack.m_41773_() < 2) continue;
                AutoFish.LOGGER.info("Found fishing rod for replacement");
                player.m_150109_().f_35977_ = i;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
        }
        pendingRecast = true;
    }

    private static void recast(Player player) {
        if (!autofish) {
            return;
        }
        InteractionHand hand = AutoFishHandler.findHandOfRod(player);
        if (hand == null) {
            return;
        }
        ItemStack fishingRod = player.m_21120_(hand);
        if (fishingRod.m_41619_()) {
            return;
        }
        AutoFishHandler.click(player.f_19853_, player, hand, Minecraft.m_91087_().f_91072_);
    }

    private static void dropItem(Player player) {
        MultiPlayerGameMode playerController = Minecraft.m_91087_().f_91072_;
        if (playerController == null) {
            shouldDrop.clear();
            return;
        }
        processingDrop = true;
        ArrayList shouldRemove = Lists.newArrayList();
        for (Item item : shouldDrop) {
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (!stack.m_41720_().equals(item) || player.m_150109_().m_36030_(stack) == player.m_150109_().f_35977_) continue;
                int slot = player.m_150109_().m_36030_(stack);
                playerController.m_171799_(player.f_36096_.f_38840_, slot, 0, ClickType.THROW, player);
                shouldRemove.add(item);
            }
        }
        shouldDrop.removeAll(shouldRemove);
        processingDrop = false;
    }

    private static void click(Level world, Player player, InteractionHand hand, @Nullable MultiPlayerGameMode controller) {
        if (controller == null) {
            return;
        }
        controller.m_105235_(player, world, hand);
    }

    @Nullable
    private static InteractionHand findHandOfRod(Player player) {
        if (player.m_21205_().m_41720_() instanceof FishingRodItem) {
            return InteractionHand.MAIN_HAND;
        }
        if (player.m_21206_().m_41720_() instanceof FishingRodItem) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    private static Component getText(String key, boolean bool) {
        return new TranslatableComponent("toggle." + key, new Object[]{new TranslatableComponent("toggle.enable." + bool).m_130940_(bool ? ChatFormatting.GREEN : ChatFormatting.RED)});
    }
}

