/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.providers;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import snownee.jade.Util;

public class BrewingStandProvider
implements IWailaDataProvider {
    public static final BrewingStandProvider INSTANCE = new BrewingStandProvider();

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("jade.brewingstand") || !accessor.getNBTData().func_150297_b("BrewingStand", 10)) {
            return tooltip;
        }
        NBTTagCompound tag = accessor.getNBTData().func_74775_l("BrewingStand");
        int fuel = tag.func_74762_e("fuel");
        String s = Util.wailaStack(new ItemStack(Items.field_151065_br)) + Util.offsetText(I18n.func_135052_a((String)"jade.brewingStand.fuel", (Object[])new Object[]{fuel}), 0, 4);
        int time = tag.func_74762_e("time");
        if (time > 0) {
            s = s + Util.span(5, 0) + Util.wailaStack(new ItemStack(Items.field_151113_aN)) + Util.offsetText(I18n.func_135052_a((String)"jade.brewingStand.time", (Object[])new Object[]{time / 20}), 0, 4);
        }
        tooltip.add(s);
        return tooltip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (player.func_70093_af() && te instanceof TileEntityBrewingStand) {
            TileEntityBrewingStand brewingStand = (TileEntityBrewingStand)te;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("time", brewingStand.func_174887_a_(0));
            compound.func_74768_a("fuel", brewingStand.func_174887_a_(1));
            tag.func_74782_a("BrewingStand", (NBTBase)compound);
        }
        return tag;
    }
}

