/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.providers;

import java.util.Collection;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PotionEffectsProvider
implements IWailaEntityProvider {
    public static final PotionEffectsProvider INSTANCE = new PotionEffectsProvider();

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        if (!(accessor.getPlayer().func_70093_af() && config.getConfig("jade.potioneffects") && accessor.getNBTData().func_74764_b("Potions"))) {
            return currenttip;
        }
        NBTTagList list = accessor.getNBTData().func_150295_c("Potions", 10);
        String[] lines = new String[list.func_74745_c()];
        for (int i = 0; i < lines.length; ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            int duration = compound.func_74762_e("Duration");
            String name = I18n.func_135052_a((String)compound.func_74779_i("Name"), (Object[])new Object[0]);
            String amplifier = I18n.func_135052_a((String)("potion.potency." + compound.func_74762_e("Amplifier")), (Object[])new Object[0]);
            String s = I18n.func_135052_a((String)"jade.potion", (Object[])new Object[]{name, amplifier, PotionEffectsProvider.getPotionDurationString(duration)});
            lines[i] = (compound.func_74767_n("Bad") ? TextFormatting.RED : TextFormatting.GREEN) + s;
        }
        currenttip.add(SpecialChars.getRenderString((String)"jade.border", (String[])lines));
        return currenttip;
    }

    public static String getPotionDurationString(int duration) {
        if (duration == Short.MAX_VALUE) {
            return "**:**";
        }
        int i = MathHelper.func_76141_d((float)duration);
        return PotionEffectsProvider.ticksToElapsedTime(i);
    }

    public static String ticksToElapsedTime(int ticks) {
        int i = ticks / 20;
        int j = i / 60;
        return (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, Entity entity, NBTTagCompound tag, World world) {
        if (!player.func_70093_af()) {
            return tag;
        }
        NBTTagList list = new NBTTagList();
        EntityLivingBase living = (EntityLivingBase)entity;
        Collection effects = living.func_70651_bq();
        if (effects.isEmpty()) {
            return tag;
        }
        for (PotionEffect effect : effects) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("Name", effect.func_76453_d());
            compound.func_74768_a("Amplifier", effect.func_76458_c());
            compound.func_74768_a("Duration", effect.func_76459_b());
            compound.func_74757_a("Bad", effect.func_188419_a().func_76398_f());
            list.func_74742_a((NBTBase)compound);
        }
        tag.func_74782_a("Potions", (NBTBase)list);
        return tag;
    }
}

