/*
 * Decompiled with CFR 0.152.
 */
package com.crashbox.throwabletorchmod;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityThrowableTorch
extends EntityThrowable {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    private final boolean _ignites;

    protected EntityThrowableTorch(World world, boolean ignites) {
        super(world);
        this._ignites = ignites;
    }

    protected EntityThrowableTorch(World world, EntityPlayer playerEntity, boolean ignites) {
        super(world, (EntityLivingBase)playerEntity);
        this._ignites = ignites;
    }

    protected EntityThrowableTorch(World world, double x, double y, double z, boolean ignites) {
        super(world, x, y, z);
        this._ignites = ignites;
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        if (!this.field_70170_p.field_72995_K) {
            int z;
            int y;
            int x;
            IBlockState state;
            BlockPos pos = mop.func_178782_a();
            Block placeBlock = Blocks.field_150478_aa;
            IBlockState withFacing = state = placeBlock.func_176223_P();
            Action action = Action.PLACE;
            if (mop.field_72308_g != null) {
                Entity entity = mop.field_72308_g;
                x = (int)entity.field_70165_t;
                y = (int)entity.field_70163_u;
                z = (int)entity.field_70161_v;
                if (!entity.func_70045_F()) {
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.func_85052_h()), 1.0f);
                    if (this._ignites) {
                        action = Action.NONE;
                        entity.func_70015_d(6);
                    } else {
                        action = Action.DROP;
                    }
                }
            } else {
                x = pos.func_177958_n();
                y = pos.func_177956_o();
                z = pos.func_177952_p();
                Block block = this.field_70170_p.func_180495_p(pos).func_177230_c();
                if (block.func_149688_o() == Material.field_151582_l) {
                    action = Action.DESTROY_PLACE;
                } else {
                    switch (mop.field_178784_b) {
                        case DOWN: {
                            --y;
                            break;
                        }
                        case UP: {
                            ++y;
                            break;
                        }
                        case NORTH: {
                            withFacing = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
                            --z;
                            break;
                        }
                        case SOUTH: {
                            withFacing = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
                            ++z;
                            break;
                        }
                        case WEST: {
                            withFacing = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST);
                            --x;
                            break;
                        }
                        case EAST: {
                            withFacing = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST);
                            ++x;
                        }
                    }
                    pos = new BlockPos(x, y, z);
                }
            }
            switch (action) {
                case PLACE: {
                    if (this.field_70170_p.func_175623_d(pos)) {
                        this.field_70170_p.func_175656_a(pos, withFacing);
                        break;
                    }
                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, (double)x, (double)y, (double)z, new ItemStack(placeBlock)));
                    break;
                }
                case DESTROY_PLACE: {
                    this.field_70170_p.func_175655_b(pos, true);
                    this.field_70170_p.func_175656_a(pos, placeBlock.func_176223_P());
                    break;
                }
                case DROP: {
                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, (double)x, (double)y, (double)z, new ItemStack(placeBlock)));
                    break;
                }
            }
            this.func_70106_y();
        }
    }

    private static enum Action {
        PLACE,
        DESTROY_PLACE,
        DROP,
        NONE;

    }
}

