/*
 * Decompiled with CFR 0.152.
 */
package Coloryr.AllMusic.player.decoder.flac;

import Coloryr.AllMusic.player.decoder.flac.AbstractFlacLowLevelInput;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.URL;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public final class SeekableFileFlacInput
extends AbstractFlacLowLevelInput {
    private BufferedInputStream raf;
    private final HttpGet get;
    private final HttpClient client;
    private InputStream content;
    private long local;

    public SeekableFileFlacInput(HttpClient client, URL url) throws Exception {
        this.client = client;
        this.get = new HttpGet(url.toString());
        this.get.setHeader("Range", "bytes=" + this.local + "-");
        HttpResponse response = this.client.execute((HttpUriRequest)this.get);
        HttpEntity entity = response.getEntity();
        this.content = entity.getContent();
        this.raf = new BufferedInputStream(this.content);
    }

    @Override
    public long getLength() {
        try {
            return this.raf.available();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected int readUnderlying(byte[] buf, int off, int len) throws IOException {
        try {
            int temp = this.raf.read(buf, off, len);
            this.local += (long)temp;
            return temp;
        }
        catch (SocketException | ConnectionClosedException ex) {
            this.get.setHeader("Range", "bytes=" + this.local + "-");
            HttpResponse response = this.client.execute((HttpUriRequest)this.get);
            HttpEntity entity = response.getEntity();
            this.content = entity.getContent();
            this.raf = new BufferedInputStream(this.content);
            return this.readUnderlying(buf, off, len);
        }
    }

    @Override
    public void close() throws IOException {
        this.get.abort();
        if (this.raf != null) {
            this.raf.close();
            this.raf = null;
            super.close();
        }
    }
}

