/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.api.crafting;

import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeWrapper
implements IRecipe {
    private IRecipe recipe;
    private int time;
    private int cost;
    private Object[] input;
    private boolean hasEmptyList = false;

    public RecipeWrapper(IRecipe recipe) {
        this.recipe = recipe;
        this.time = 200;
        this.cost = 200;
        if (recipe instanceof ShapedOreRecipe) {
            ShapedOreRecipe shaped = (ShapedOreRecipe)recipe;
            for (Object in : this.input = shaped.getInput()) {
                if (in == null || !(in instanceof List) || !((List)in).isEmpty()) continue;
                this.hasEmptyList = true;
            }
        } else if (recipe instanceof ShapelessOreRecipe) {
            ShapelessOreRecipe shapeless = (ShapelessOreRecipe)recipe;
            for (Object in : this.input = shapeless.getInput().toArray(new Object[0])) {
                if (in == null || !(in instanceof List) || !((List)in).isEmpty()) continue;
                this.hasEmptyList = true;
            }
        } else if (recipe instanceof ShapedRecipes) {
            ShapedRecipes shaped = (ShapedRecipes)recipe;
            this.input = shaped.field_77574_d;
        } else if (recipe instanceof ShapelessRecipes) {
            ShapelessRecipes shapeless = (ShapelessRecipes)recipe;
            this.input = shapeless.field_77579_b.toArray(new Object[0]);
        } else {
            this.input = new Object[9];
        }
    }

    public RecipeWrapper setTotalCookTime(int time) {
        this.time = time;
        return this;
    }

    public RecipeWrapper setFuelCost(int cost) {
        this.cost = cost;
        return this;
    }

    public boolean hasEmptyList() {
        return this.hasEmptyList;
    }

    public Object[] getInputTable() {
        return this.input;
    }

    public IRecipe getRecipe() {
        return this.recipe;
    }

    public int getTotalCookTime() {
        return this.time;
    }

    public int getFuelCost() {
        return this.cost;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return this.recipe.func_77569_a(inv, worldIn);
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.recipe.func_77572_b(inv);
    }

    public int func_77570_a() {
        return this.recipe.func_77570_a();
    }

    public ItemStack func_77571_b() {
        return this.recipe.func_77571_b();
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        return this.recipe.func_179532_b(inv);
    }
}

