/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ruby.bamboo.api.BambooBlocks;
import ruby.bamboo.core.init.BambooData;
import ruby.bamboo.core.init.EnumCreateTab;
import ruby.bamboo.core.init.EnumMaterial;
import ruby.bamboo.item.itemblock.ItemBamboo;

@BambooData.BambooBlock(itemBlock=ItemBamboo.class, createiveTabs=EnumCreateTab.TAB_BAMBOO, material=EnumMaterial.PLANTS)
public class Bamboo
extends BlockBush
implements IGrowable {
    public static final PropertyInteger LENGTH = PropertyInteger.func_177719_a((String)"meta", (int)0, (int)15);
    public static final AxisAlignedBB BLOCK_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    public Bamboo(Material material) {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LENGTH, (Comparable)Integer.valueOf(10)));
        this.func_149713_g(0);
        this.func_149675_a(true);
        this.func_149711_c(0.75f);
        this.func_149752_b(1.0f);
        this.setHarvestLevel("axe", 0);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BLOCK_AABB;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LENGTH, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LENGTH);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LENGTH});
    }

    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XYZ;
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        return this.func_185514_i(worldIn.func_180495_p(pos.func_177977_b())) || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        BlockPos p = pos.func_177977_b();
        if (worldIn.func_180495_p(p).func_177230_c() == this) {
            this.func_176226_b(worldIn, p, state, 0);
            worldIn.func_180501_a(p, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    private void tryBambooGrowth(World world, BlockPos pos, IBlockState state, float probability) {
        if (!world.field_72995_K && world.func_175623_d(pos.func_177984_a()) && world.field_73012_v.nextFloat() < probability) {
            int meta = this.func_176201_c(state);
            if (meta > 0) {
                this.growBamboo(world, pos, meta);
            } else if (world.func_72896_J() || world.field_73012_v.nextFloat() < probability) {
                this.tryChildSpawn(world, pos, state);
            }
        }
    }

    int getLength(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LENGTH);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.tryBambooGrowth(world, pos, state, world.func_72896_J() ? 0.25f : 0.125f);
    }

    private void growBamboo(World world, BlockPos pos, int meta) {
        world.func_175656_a(pos.func_177984_a(), this.func_176203_a(--meta));
    }

    private boolean canChildSpawn(World world, BlockPos pos, IBlockState state) {
        if (world.func_175623_d(pos)) {
            BlockPos pd = pos.func_177977_b();
            if (BambooBlocks.BAMBOOSHOOT.func_180671_f(world, pos, state)) {
                float f = world.field_73012_v.nextFloat();
                float f2 = world.func_72896_J() ? 0.4f : (world.func_180495_p(pd).func_177230_c() == Blocks.field_150458_ak ? 0.25f : 0.1f);
                if (f < f2) {
                    return true;
                }
            }
        }
        return false;
    }

    private void tryChildSpawn(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            BlockPos p = pos.func_177977_b();
            while (!this.func_185514_i(world.func_180495_p(p))) {
                p = p.func_177977_b();
            }
            for (BlockPos target : BlockPos.func_177980_a((BlockPos)p.func_177982_a(-1, -1, -1), (BlockPos)p.func_177982_a(1, 1, 1))) {
                if (!this.canChildSpawn(world, target, state)) continue;
                world.func_175656_a(target.func_177977_b(), Blocks.field_150346_d.func_176223_P());
                world.func_175656_a(target, BambooBlocks.BAMBOOSHOOT.func_176223_P());
            }
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (this.func_185514_i(worldIn.func_180495_p(pos.func_177977_b()))) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)LENGTH, (Comparable)Integer.valueOf(8 + worldIn.field_73012_v.nextInt(5))));
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        BlockPos tmp = pos;
        while (!world.func_175623_d(tmp = tmp.func_177984_a())) {
            pos = tmp;
        }
        this.tryBambooGrowth(world, pos, world.func_180495_p(pos), 0.65f);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @BambooData.BambooBlock.StateIgnore
    public IProperty[] getIgnoreState() {
        return new IProperty[]{LENGTH};
    }

    public MapColor func_180659_g(IBlockState state) {
        return MapColor.field_151669_i;
    }
}

