/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ruby.bamboo.api.BambooBlocks;
import ruby.bamboo.core.init.BambooData;
import ruby.bamboo.core.init.EnumCreateTab;
import ruby.bamboo.core.init.EnumMaterial;
import ruby.bamboo.item.itemblock.ItemBambooShoot;

@BambooData.BambooBlock(itemBlock=ItemBambooShoot.class, createiveTabs=EnumCreateTab.TAB_BAMBOO, material=EnumMaterial.PLANTS)
public class BambooShoot
extends BlockBush
implements IGrowable {
    public static final PropertyInteger META = PropertyInteger.func_177719_a((String)"meta", (int)0, (int)1);
    public static final AxisAlignedBB BLOCK_AABB = new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, 0.5, (double)0.7f);

    public BambooShoot(Material material) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)META, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.func_149711_c(0.05f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BLOCK_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XYZ;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)META, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)META);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{META});
    }

    public void tryBambooGrowth(World world, BlockPos pos, IBlockState state, float prob) {
        if (!world.field_72995_K && world.field_73012_v.nextFloat() < prob && this.canChildGrow(world, pos, state)) {
            world.func_175656_a(pos, BambooBlocks.BAMBOO.func_176223_P());
        }
    }

    public boolean canChildGrow(World world, BlockPos pos, IBlockState state) {
        boolean flg = world.func_175623_d(pos.func_177984_a());
        if (flg) {
            Chunk chunk = world.func_175726_f(pos);
            flg = chunk.func_177413_a(EnumSkyBlock.BLOCK, pos) > 7;
        }
        return flg;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this);
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn) {
        if (!this.func_180671_f(world, pos, state)) {
            world.func_175698_g(pos);
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        Block ground = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        return ground == Blocks.field_150349_c || ground == Blocks.field_150346_d || ground == Blocks.field_150458_ak;
    }

    protected void func_176475_e(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_180671_f(worldIn, pos, state)) {
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.tryBambooGrowth(world, pos, state, world.func_72896_J() ? 0.25f : 0.125f);
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        this.tryBambooGrowth(world, pos, state, 0.75f);
    }

    @BambooData.BambooBlock.StateIgnore
    public IProperty[] getIgnoreState() {
        return new IProperty[]{META};
    }
}

