/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.block;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ruby.bamboo.api.BambooBlocks;
import ruby.bamboo.block.IBlockColorWrapper;
import ruby.bamboo.block.ILeave;
import ruby.bamboo.block.SakuraLeave;
import ruby.bamboo.core.init.BambooData;
import ruby.bamboo.core.init.EnumCreateTab;
import ruby.bamboo.entity.SakuraPetal;
import ruby.bamboo.item.itemblock.ItemSakuraLeave;

@BambooData.BambooBlock(name="broad_leave", itemBlock=ItemSakuraLeave.class, createiveTabs=EnumCreateTab.TAB_BAMBOO)
public class BroadLeave
extends BlockLeaves
implements ILeave,
SakuraPetal.ICustomPetal,
IBlockColorWrapper {
    private static final int metaSlide = 4;
    public static final PropertyEnum VARIANT = PropertyEnum.func_177708_a((String)"variant", SakuraLeave.EnumLeave.class, (Predicate)new Predicate(){

        public boolean apply(SakuraLeave.EnumLeave type) {
            return type.getMetadata() >= 4;
        }

        public boolean apply(Object p_apply_1_) {
            return this.apply((SakuraLeave.EnumLeave)((Object)p_apply_1_));
        }
    });

    public BroadLeave() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)SakuraLeave.EnumLeave.GREEN)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(true)));
        this.field_185686_c = true;
        this.func_149715_a(0.75f);
        this.func_149711_c(0.0f);
    }

    public int func_176201_c(IBlockState state) {
        int b0 = 0;
        int i = b0 | ((SakuraLeave.EnumLeave)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata() - 4;
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)SakuraLeave.EnumLeave.getLeave((meta & 3) + 4))).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 4) == 0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, field_176237_a, field_176236_b});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List list) {
        for (SakuraLeave.EnumLeave leave : SakuraLeave.EnumLeave.BROAD_LEAVES) {
            list.add(new ItemStack(itemIn, 1, leave.getMetadata() - 4));
        }
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        return new ArrayList<ItemStack>(Arrays.asList(new ItemStack((Block)this, 1, ((SakuraLeave.EnumLeave)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata() - 4)));
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return null;
    }

    @Override
    public String getLeaveName(int metadata) {
        return SakuraLeave.EnumLeave.getLeave(metadata + 4).func_176610_l();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)BambooBlocks.SAKURA_SAPLING);
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, ((SakuraLeave.EnumLeave)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata() - 4);
    }

    @BambooData.BambooBlock.StateIgnore
    public IProperty[] getIgnoreState() {
        return new IProperty[]{field_176237_a, field_176236_b};
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer != null) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    @Override
    public IBlockState getLeaveStateFromMeta(int meta) {
        return this.func_176203_a(meta);
    }

    @Override
    public int getLeaveRenderColor(IBlockState state) {
        return ((SakuraLeave.EnumLeave)((Object)state.func_177229_b((IProperty)VARIANT))).getColor();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (rand.nextInt(100) != 0) {
            return;
        }
        if (world.func_175623_d(pos.func_177977_b())) {
            SakuraPetal petal = new SakuraPetal(world);
            petal.func_70107_b((float)pos.func_177958_n() + rand.nextFloat(), pos.func_177956_o(), (float)pos.func_177952_p() + rand.nextFloat());
            petal.setCustomPetal(state);
            petal.setColor(this.colorMultiplier(state, (IBlockAccess)world, pos, 0));
            world.func_72838_d((Entity)petal);
        }
    }

    @Override
    public int getTexNum(IBlockState state) {
        return ((SakuraLeave.EnumLeave)((Object)state.func_177229_b((IProperty)VARIANT))).getPetal();
    }

    @Override
    public String getTexPath(IBlockState state) {
        return "bamboomod:textures/entitys/petal.png";
    }

    @Override
    public int colorMultiplier(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        return ((SakuraLeave.EnumLeave)((Object)state.func_177229_b((IProperty)VARIANT))).getColor();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.func_180643_i(state);
    }

    public MapColor func_180659_g(IBlockState state) {
        return ((SakuraLeave.EnumLeave)((Object)state.func_177229_b((IProperty)VARIANT))).getMapColor();
    }
}

