/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ruby.bamboo.core.init.BambooData;
import ruby.bamboo.core.init.EnumCreateTab;
import ruby.bamboo.gui.GuiHandler;
import ruby.bamboo.tileentity.TileCampfire;

@BambooData.BambooBlock(name="campfire", createiveTabs=EnumCreateTab.TAB_BAMBOO)
public class Campfire
extends BlockContainer {
    public static final PropertyEnum<EnumFacing> FACING = PropertyEnum.func_177709_a((String)"meta", EnumFacing.class);

    public Campfire() {
        super(Material.field_151578_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(1.0f);
        this.func_149752_b(300.0f);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        worldIn.func_180501_a(pos, state.func_177226_a(FACING, (Comparable)enumfacing), 3);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null) {
            GuiHandler.openGui(worldIn, playerIn, 2, pos);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        float var7 = (float)pos.func_177958_n() + 0.5f;
        float var8 = (float)pos.func_177956_o() + 0.2f;
        float var9 = (float)pos.func_177952_p() + 0.5f;
        float var10 = rand.nextFloat() * 0.4f - 0.2f;
        float var11 = rand.nextFloat() * 0.4f - 0.2f;
        if (rand.nextFloat() < 0.1f) {
            world.func_175688_a(EnumParticleTypes.FLAME, (double)(var7 + var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileCampfire) {
            for (ItemStack stack : ((TileCampfire)tile).getInventorySlots()) {
                if (stack == null) continue;
                Campfire.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileCampfire();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @BambooData.BambooBlock.StateIgnore
    public IProperty[] getIgnoreState() {
        return new IProperty[]{FACING};
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.IGNORE;
    }

    public MapColor func_180659_g(IBlockState state) {
        return MapColor.field_151660_b;
    }
}

