/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public abstract class GrowableBase
extends BlockBush
implements IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)4);
    public static final AxisAlignedBB BLOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);

    public GrowableBase() {
        this.func_149647_a(null);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149649_H();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BLOCK_AABB;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public void tryBonemealGrow(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        int meta = this.func_176201_c(state) + MathHelper.func_76136_a((Random)world.field_73012_v, (int)1, (int)2);
        if (meta > this.getMaxGrowthStage()) {
            meta = this.getMaxGrowthStage();
        }
        world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta)), 2);
    }

    public abstract Item getSeed();

    public abstract Item getProduct();

    public abstract EnumPlantType getPlantType(IBlockAccess var1, BlockPos var2);

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        float f;
        int l;
        super.func_180650_b(world, pos, state, rand);
        if (world.func_175671_l(pos.func_177984_a()) >= 9 && (l = this.func_176201_c(state)) < this.getMaxGrowthStage() && rand.nextInt((int)(25.0f / (f = this.getGrowRate(state.func_177230_c(), world, pos))) + 1) == 0) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(++l)), 2);
        }
    }

    public float getGrowRate(Block blockIn, World worldIn, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos1 = pos.func_177977_b();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                IBlockState iblockstate = worldIn.func_180495_p(blockpos1.func_177982_a(i, 0, j));
                boolean isSutainPlant = iblockstate.func_177230_c().canSustainPlant(iblockstate, (IBlockAccess)worldIn, pos, EnumFacing.UP, (IPlantable)blockIn);
                if (isSutainPlant) {
                    f1 = 1.0f;
                    if (iblockstate.func_177230_c().isFertile(worldIn, blockpos1.func_177982_a(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos2 = pos.func_177978_c();
        BlockPos blockpos3 = pos.func_177968_d();
        BlockPos blockpos4 = pos.func_177976_e();
        BlockPos blockpos5 = pos.func_177974_f();
        boolean flag = blockIn == worldIn.func_180495_p(blockpos4).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos5).func_177230_c();
        boolean bl = flag1 = blockIn == worldIn.func_180495_p(blockpos2).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos3).func_177230_c();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = blockIn == worldIn.func_180495_p(blockpos4.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos5.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos5.func_177968_d()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177968_d()).func_177230_c();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        super.func_180653_a(world, pos, state, chance, 0);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ((Integer)state.func_177229_b((IProperty)AGE)).intValue() == this.getMaxGrowthStage() ? this.getProduct() : this.getSeed();
    }

    public int func_149745_a(Random rand) {
        return 1;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand;
        List ret = super.getDrops(world, pos, state, fortune);
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        Random random = rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        if (age >= this.getMaxGrowthStage()) {
            for (int i = 0; i < 3 + fortune; ++i) {
                if (!(rand.nextFloat() <= this.getDropRate(age))) continue;
                ret.add(new ItemStack(this.getSeed(), 1, 0));
            }
        }
        this.extraDrop(world, pos, state, fortune, ret, age);
        return ret;
    }

    float getDropRate(int age) {
        return (float)(age / this.getMaxGrowthStage()) / 2.0f;
    }

    List<ItemStack> extraDrop(IBlockAccess world, BlockPos pos, IBlockState state, int fortune, List<ItemStack> list, int age) {
        return list;
    }

    public abstract int getMaxGrowthStage();

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)AGE) < this.getMaxGrowthStage();
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        this.tryBonemealGrow(world, pos);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(this.getSeed());
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.canPlaceBlockOn(worldIn.func_180495_p(pos).func_177230_c());
    }

    public boolean canPlaceBlockOn(Block block) {
        return false;
    }
}

