/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.block;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ruby.bamboo.core.init.BambooData;
import ruby.bamboo.core.init.EnumCreateTab;
import ruby.bamboo.core.init.SubBlockBase;
import ruby.bamboo.item.itemblock.ItemIndLight;

@BambooData.BambooBlock(itemBlock=ItemIndLight.class, jsonName="indlight", createiveTabs=EnumCreateTab.TAB_BAMBOO, subblock=SubBlock.class)
public class IndLight
extends BlockDirectional {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool SECOND_LINK = PropertyBool.func_177716_a((String)"secondlink");
    public static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.0, 0.9, 0.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1, 1.0);
    public static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.9, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1);
    public static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.9, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1, 1.0, 1.0);
    public final EnumDyeColor color;

    public IndLight(SubBlock data) {
        super(Material.field_151578_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)SECOND_LINK, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(0.3f);
        this.func_149752_b(300.0f);
        SubBlock blockdata = data;
        this.color = blockdata.color;
        this.func_149663_c("indlight_" + this.color.func_176610_l());
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a((IProperty)field_176387_N, (Comparable)facing.func_176734_d()).func_177226_a((IProperty)SECOND_LINK, (Comparable)Boolean.valueOf(placer.func_70093_af()));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)field_176387_N);
        switch (enumfacing) {
            case DOWN: {
                return DOWN_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case UP: {
                return UP_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
        }
        return super.func_185496_a(state, source, pos);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 15;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)) {
            case UP: {
                return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.NORTH))))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH))))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.EAST))))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.WEST)))));
            }
            case DOWN: {
                return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH))))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.NORTH))))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.EAST))))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.WEST)))));
            }
            case NORTH: {
                return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.UP))))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.DOWN))))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.WEST))))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.EAST)))));
            }
            case SOUTH: {
                return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.UP))))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.DOWN))))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.EAST))))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.WEST)))));
            }
            case EAST: {
                return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.UP))))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.DOWN))))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.NORTH))))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH)))));
            }
            case WEST: {
                return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.UP))))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.DOWN))))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH))))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canChain(state, worldIn.func_180495_p(pos.func_177972_a(EnumFacing.NORTH)))));
            }
        }
        return super.func_176221_a(state, worldIn, pos);
    }

    private boolean canChain(IBlockState state, IBlockState targetState) {
        return targetState.func_177230_c() == this && state.func_177229_b((IProperty)SECOND_LINK) == targetState.func_177229_b((IProperty)SECOND_LINK) && targetState.func_177229_b((IProperty)field_176387_N) == state.func_177229_b((IProperty)field_176387_N);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)SECOND_LINK, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176745_a() + ((Boolean)state.func_177229_b((IProperty)SECOND_LINK) != false ? 8 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176387_N, NORTH, EAST, SOUTH, WEST, SECOND_LINK});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @BambooData.BambooBlock.StateIgnore
    public IProperty[] getIgnoreState() {
        return new IProperty[]{SECOND_LINK};
    }

    public MapColor func_180659_g(IBlockState state) {
        return MapColor.field_151660_b;
    }

    public static class SubBlock
    implements SubBlockBase {
        private EnumDyeColor color;

        public SubBlock() {
        }

        public SubBlock(EnumDyeColor color) {
            this.color = color;
        }

        public List<SubBlock> getList() {
            return Arrays.stream(EnumDyeColor.values()).map(dye -> new SubBlock((EnumDyeColor)dye)).collect(Collectors.toList());
        }
    }
}

