/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.block;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ruby.bamboo.api.BambooBlocks;
import ruby.bamboo.block.BroadLeave;
import ruby.bamboo.block.SakuraLeave;
import ruby.bamboo.core.init.BambooData;
import ruby.bamboo.core.init.EnumCreateTab;
import ruby.bamboo.generate.GenSakuraBigTree;
import ruby.bamboo.generate.GenSakuraTree;

@BambooData.BambooBlock(name="sakura_sapling", createiveTabs=EnumCreateTab.TAB_BAMBOO)
public class SakuraSapling
extends BlockSapling
implements IGrowable {
    public SakuraSapling() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176479_b, (Comparable)Integer.valueOf(0)));
        float f = 0.4f;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.func_176474_b(worldIn, rand, pos, state);
            }
        }
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)field_176479_b) == 0) {
            worldIn.func_180501_a(pos, state.func_177231_a((IProperty)field_176479_b), 4);
        } else {
            this.func_176476_e(worldIn, pos, state, rand);
        }
    }

    public void func_176476_e(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        WorldGenAbstractTree object = rand.nextInt(10) == 0 ? new GenSakuraBigTree(true) : new GenSakuraTree(true);
        this.generate(worldIn, pos, state, rand, object);
    }

    private void generate(World worldIn, BlockPos pos, IBlockState state, Random rand, WorldGenAbstractTree tree) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        int i = 0;
        int j = 0;
        boolean flag = false;
        worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 4);
        if (!tree.func_180709_b(worldIn, rand, pos.func_177982_a(i, 0, j))) {
            worldIn.func_180501_a(pos, state, 4);
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176479_b, field_176480_a});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176479_b, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)field_176479_b);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && heldItem != null && heldItem.func_77973_b() == Items.field_151100_aR) {
            Random rand = worldIn.field_73012_v;
            if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
                return false;
            }
            SakuraLeave.EnumLeave leave = SakuraLeave.EnumLeave.getLeaveFromDye(heldItem.func_77952_i());
            IBlockState leaveState = BambooBlocks.SAKURA_LEAVE.func_176223_P();
            PropertyEnum prop = SakuraLeave.VARIANT;
            if (Arrays.binarySearch((Object[])SakuraLeave.EnumLeave.BROAD_LEAVES, (Object)leave) > 0) {
                leaveState = BambooBlocks.BROAD_LEAVE.func_176223_P();
                prop = BroadLeave.VARIANT;
            }
            WorldGenAbstractTree object = rand.nextInt(10) == 0 ? new GenSakuraBigTree(true, leaveState.func_177226_a((IProperty)prop, (Comparable)((Object)leave))) : new GenSakuraTree(true, leaveState.func_177226_a((IProperty)prop, (Comparable)((Object)leave)));
            this.generate(worldIn, pos, state, rand, object);
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(itemIn));
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public boolean func_176477_a(World worldIn, BlockPos pos, BlockPlanks.EnumType type) {
        return false;
    }

    @BambooData.BambooBlock.StateIgnore
    public IProperty[] getIgnoreState() {
        return new IProperty[]{field_176479_b, field_176480_a};
    }
}

