/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.block;

import java.util.Random;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ruby.bamboo.core.init.BambooData;
import ruby.bamboo.core.init.EnumMaterial;
import ruby.bamboo.paticle.PaticleFactory;
import ruby.bamboo.tileentity.TileSpringWater;

@BambooData.BambooBlock(name="spring_water", material=EnumMaterial.WATER)
@BambooData.JEIIgnore
public class SpringWater
extends BlockFluidFinite
implements ITileEntityProvider {
    private static final byte MAX_LV = 8;

    public SpringWater(Material material) {
        super(FluidRegistry.getFluid((String)"bamboo_hot_spring"), material);
        this.setTickRate(30);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileSpringWater();
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        TileSpringWater myTile = (TileSpringWater)worldIn.func_175625_s(pos);
        if (myTile.getParent() != null) {
            return;
        }
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos parent;
            BlockPos offPos = pos.func_177972_a(dir);
            IBlockState offState = worldIn.func_180495_p(offPos);
            if (offState == null || offState.func_177230_c() != this || (parent = ((TileSpringWater)worldIn.func_175625_s(offPos)).getParent()) == null) continue;
            myTile.setParent(parent);
            return;
        }
        ((TileSpringWater)worldIn.func_175625_s(pos)).setParent(pos);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        TileSpringWater water = (TileSpringWater)world.func_175625_s(pos);
        if (water == null) {
            return;
        }
        if (water.getParent() == null || water.isDead()) {
            SpringWater.levelDown(world, pos, state);
            return;
        }
        if (!water.isParent()) {
            if (!water.isParentAlive()) {
                water.setDead();
            } else {
                int level = 8;
                BlockPos updatePos = null;
                for (EnumFacing dir : EnumFacing.field_176754_o) {
                    int offLv;
                    BlockPos off = pos.func_177972_a(dir);
                    IBlockState offState = world.func_180495_p(off);
                    if (offState.func_177230_c() != this || (offLv = ((Integer)offState.func_177229_b((IProperty)LEVEL)).intValue()) >= level) continue;
                    updatePos = off;
                    level = offLv;
                }
                if (updatePos != null) {
                    SpringWater.levelUp(world, updatePos);
                }
            }
        }
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() != this) {
            super.func_180650_b(world, pos, state, rand);
        } else {
            SpringWater.levelUp(world, pos.func_177977_b());
        }
    }

    public static boolean levelUp(World world, BlockPos pos) {
        return SpringWater.levelUp(world, pos, world.func_180495_p(pos));
    }

    public static boolean levelUp(World world, BlockPos pos, IBlockState state) {
        int level = (Integer)state.func_177229_b((IProperty)LEVEL);
        if (level < 8) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(++level)));
            world.func_175684_a(pos, state.func_177230_c(), state.func_177230_c().func_149738_a(world));
            return true;
        }
        return false;
    }

    public static void levelDown(World world, BlockPos pos, IBlockState state) {
        int level = (Integer)state.func_177229_b((IProperty)LEVEL);
        if (level < 1) {
            world.func_175698_g(pos);
        } else {
            world.func_175656_a(pos, state.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(--level)));
            world.func_175684_a(pos, state.func_177230_c(), state.func_177230_c().func_149738_a(world));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (rand.nextInt(10) != 0) {
            return;
        }
        if (world.func_175623_d(pos.func_177984_a())) {
            double d0 = (double)pos.func_177958_n() + (double)rand.nextFloat();
            double d1 = (double)pos.func_177956_o() + 1.1;
            double d2 = (double)pos.func_177952_p() + (double)rand.nextFloat();
            PaticleFactory.createColoerSomoke(world, d0, d1, d2, 0xEEEEEE);
        }
    }
}

