/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.block.decoration;

import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.GameRegistry;
import ruby.bamboo.block.decoration.DecorationBlock;
import ruby.bamboo.block.decoration.DecorationDoubleSlab;
import ruby.bamboo.block.decoration.DecorationSlab;
import ruby.bamboo.block.decoration.DecorationStairs;
import ruby.bamboo.block.decoration.EnumDecoration;
import ruby.bamboo.core.init.EnumCreateTab;
import ruby.bamboo.item.itemblock.ItemDecorationSlab;

public class DecorationFactory {
    public void register() {
        for (EnumDecoration deco : EnumDecoration.values()) {
            if (deco.isNormal()) {
                this.registerNormal(deco);
            }
            if (deco.isHalf()) {
                this.registerDoubleSlab(deco);
                this.registerSlab(deco);
            }
            if (!deco.isStair()) continue;
            this.registerStair(deco);
        }
    }

    void registerNormal(EnumDecoration deco) {
        DecorationBlock block = new DecorationBlock(deco.getMaterial(), deco.getMapColor());
        this.registerBlock(block, ItemBlock.class, deco.getName(), deco.getCreateTab(), new Object[0]);
    }

    void registerDoubleSlab(EnumDecoration deco) {
        DecorationDoubleSlab doubleSlab = new DecorationDoubleSlab(deco.getMaterial(), deco.getModName() + "_slab", deco);
        this.registerBlock((Block)doubleSlab, ItemBlock.class, deco.getName() + "_double_slab", EnumCreateTab.NONE, new Object[0]);
    }

    void registerSlab(EnumDecoration deco) {
        DecorationSlab singleSlab = new DecorationSlab(deco.getMaterial(), deco);
        this.registerBlock((Block)singleSlab, ItemDecorationSlab.class, deco.getName() + "_slab", deco.getCreateTab(), new Object[]{singleSlab, Block.func_149684_b((String)(deco.getModName() + "_double_slab"))});
    }

    void registerStair(EnumDecoration deco) {
        DecorationStairs block = new DecorationStairs(Block.func_149684_b((String)deco.getModName()).func_176223_P(), deco);
        this.registerBlock((Block)block, ItemBlock.class, deco.getName() + "_stairs", deco.getCreateTab(), new Object[0]);
    }

    private void registerBlock(Block block, Class<? extends ItemBlock> item, String name, EnumCreateTab tab, Object ... obj) {
        if (tab != EnumCreateTab.NONE) {
            block.func_149647_a(tab.getTabInstance());
        }
        block.func_149663_c(name);
        if (obj.length == 0) {
            GameRegistry.registerBlock((Block)block, item, (String)name);
        } else {
            GameRegistry.registerBlock((Block)block, item, (String)name, (Object[])obj);
        }
        FMLLog.info((String)"BLOCK: %s to Registed", (Object[])new Object[]{name});
    }
}

