/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.block.decoration;

import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import ruby.bamboo.core.init.EnumCreateTab;

public enum EnumDecoration {
    KAWARA("kawara"),
    PLASTER("plaster"),
    NAMAKO("namako"),
    WARA("wara"),
    KAYA("kaya"),
    CBIRCH("cbirch"),
    COAK("coak"),
    CPINE("cpine");

    public static final String SLAB = "_slab";
    public static final String DOUBLE_SLAB = "_double_slab";
    public static final String STAIRS = "_stairs";
    private static final byte NORMAL = 1;
    private static final byte HALF = 2;
    private static final byte STAIR = 4;
    private String name;
    private Material material;
    private EnumCreateTab tab;
    private byte typeFlg;

    private EnumDecoration(String name) {
        this(name, Material.field_151578_c, EnumCreateTab.TAB_BAMBOO, 1, 2, 4);
    }

    private EnumDecoration(String name, Material material, EnumCreateTab tab, byte ... typeFlg) {
        this.name = name;
        this.material = material;
        this.tab = tab;
        byte flg = 0;
        for (byte b : typeFlg) {
            flg = (byte)(flg + b);
        }
        this.typeFlg = flg;
    }

    public String getName() {
        return this.name;
    }

    public String getModName() {
        return "bamboomod:" + this.name;
    }

    public Material getMaterial() {
        return this.material;
    }

    public MapColor getMapColor() {
        switch (this) {
            case CBIRCH: {
                return MapColor.field_151663_o;
            }
            case COAK: {
                return MapColor.field_151663_o;
            }
            case CPINE: {
                return MapColor.field_151663_o;
            }
            case KAWARA: {
                return MapColor.field_151670_w;
            }
            case KAYA: {
                return MapColor.field_151650_B;
            }
            case NAMAKO: {
                return MapColor.field_151670_w;
            }
            case PLASTER: {
                return MapColor.field_151677_p;
            }
            case WARA: {
                return MapColor.field_151673_t;
            }
        }
        return MapColor.field_151660_b;
    }

    public EnumCreateTab getCreateTab() {
        return this.tab;
    }

    public boolean isNormal() {
        return (this.typeFlg & 1) != 0;
    }

    public boolean isHalf() {
        return (this.typeFlg & 2) != 0;
    }

    public boolean isStair() {
        return (this.typeFlg & 4) != 0;
    }
}

