/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.command;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ATCommand
extends CommandBase {
    public int func_82362_a() {
        return 2;
    }

    public String func_71517_b() {
        return "autotorch";
    }

    public String func_71518_a(ICommandSender sender) {
        return "auto building torch from args chunks";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2) {
            sender.func_145747_a((ITextComponent)new TextComponentString("args1:chunk range number. args2: thread num"));
            return;
        }
        if (!(sender.func_174793_f() instanceof EntityPlayer)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("this command is EntityPlayer and CreativeMode only"));
            return;
        }
        if (!((EntityPlayer)sender.func_174793_f()).field_71075_bZ.field_75098_d) {
            sender.func_145747_a((ITextComponent)new TextComponentString("this command is CreativeMode only"));
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)new AutoTorchScan(sender, Integer.parseInt(args[0]), Integer.parseInt(args[1])));
    }

    public class AutoTorcPlacer {
        private ICommandSender sender;
        private final World startWorld;
        LinkedList<BlockPos> posList;
        private int totalBlock;
        private int totalTorch;
        private long stateTime;

        public AutoTorcPlacer(LinkedList<BlockPos> posList, ICommandSender sender) {
            this.startWorld = sender.func_130014_f_();
            this.sender = sender;
            this.posList = posList;
            this.totalBlock = posList.size();
            this.stateTime = System.currentTimeMillis();
        }

        @SubscribeEvent
        public void tick(TickEvent.ServerTickEvent e) {
            block1: {
                int i = 0;
                while (!this.posList.isEmpty()) {
                    BlockPos pos = this.posList.pollFirst();
                    if (this.startWorld.func_175642_b(EnumSkyBlock.BLOCK, pos) >= 8) continue;
                    this.startWorld.func_180501_a(pos, Blocks.field_150478_aa.func_176223_P(), 2);
                    ++this.totalTorch;
                    if (i++ <= this.totalBlock / 100) continue;
                    break block1;
                }
                this.addChat("torch add end");
                this.addChat("Check:" + this.totalBlock + "Block.  " + this.totalTorch + " torch added");
                this.addChat("time:" + (System.currentTimeMillis() - this.stateTime) + "ms");
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                return;
            }
            this.addChat("remaining:" + this.posList.size());
        }

        private void addChat(String str) {
            this.sender.func_145747_a((ITextComponent)new TextComponentString(str));
        }
    }

    public class AutoTorchScan {
        private LinkedList<BlockPos> posList = Lists.newLinkedList();
        private Searcher[] searches;
        private final ICommandSender sender;
        private final World startWorld;

        public AutoTorchScan(ICommandSender sender, int chunkRange, int threadNum) {
            this.sender = sender;
            this.startWorld = sender.func_130014_f_();
            this.searches = new Searcher[threadNum];
            for (int i = 0; i < this.searches.length; ++i) {
                this.searches[i] = new Searcher(this, sender.func_130014_f_());
            }
            BlockPos pos = sender.func_180425_c();
            ArrayList chunkList = Lists.newArrayList();
            for (int x = -chunkRange; x <= chunkRange; ++x) {
                for (int z = -chunkRange; z <= chunkRange; ++z) {
                    chunkList.add(this.startWorld.func_72964_e((pos.func_177958_n() >> 4) + x, (pos.func_177952_p() >> 4) + z));
                }
            }
            for (int i = 0; i < chunkList.size(); ++i) {
                this.searches[i % this.searches.length].addTargetChunk((Chunk)chunkList.get(i));
            }
            for (Searcher s : this.searches) {
                s.start();
            }
        }

        public synchronized void addQueue(List<BlockPos> pos) {
            this.posList.addAll(pos);
        }

        @SubscribeEvent
        public void tick(TickEvent.WorldTickEvent e) {
            if (e.world == this.startWorld) {
                boolean isSearchEnd = true;
                for (Searcher s : this.searches) {
                    if (!s.isAlive()) continue;
                    isSearchEnd = false;
                    break;
                }
                if (isSearchEnd) {
                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                    this.addChat("Scan end,start torch add");
                    MinecraftForge.EVENT_BUS.register((Object)new AutoTorcPlacer(this.posList, this.sender));
                }
            }
        }

        private void addChat(String str) {
            this.sender.func_145747_a((ITextComponent)new TextComponentString(str));
        }

        private class Searcher
        extends Thread {
            final AutoTorchScan at;
            final World world;
            private List<Chunk> chunkList = Lists.newArrayList();

            Searcher(AutoTorchScan at, World world) {
                this.world = world;
                this.at = at;
            }

            public void addTargetChunk(Chunk chunk) {
                this.chunkList.add(chunk);
            }

            @Override
            public void run() {
                ArrayList posList = Lists.newArrayListWithCapacity((int)4096);
                for (Chunk c : this.chunkList) {
                    for (int i = 0; i < c.func_76587_i().length; ++i) {
                        ExtendedBlockStorage e = c.func_76587_i()[i];
                        if (e == Chunk.field_186036_a) continue;
                        for (int x = 0; x < 16; ++x) {
                            for (int y = 0; y < 16; ++y) {
                                for (int z = 0; z < 16; ++z) {
                                    IBlockState state;
                                    BlockPos pos = new BlockPos((c.field_76635_g << 4) + x, (i << 4) + y, (c.field_76647_h << 4) + z);
                                    if (AutoTorchScan.this.startWorld.func_180495_p(pos.func_177977_b()).func_185904_a().func_76222_j() || (state = e.func_177485_a(x, y, z)).func_185904_a() == Material.field_151586_h || !state.func_185904_a().func_76222_j() || !Blocks.field_150478_aa.func_176196_c(AutoTorchScan.this.startWorld, pos)) continue;
                                    posList.add(pos);
                                }
                            }
                        }
                    }
                }
                this.at.addQueue(posList);
            }
        }
    }
}

