/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.core.client;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class KeyBindFactory {
    public static final KeyBinding KEY_UTIL = new KeyBinding("key.bamboomod_utilkey", 47, "key.categories.gameplay");
    private static KeyBinding[] keyArray;
    private static Map<KeyBinding, IKey> map;

    public static void preInit() {
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_UTIL);
        MinecraftForge.EVENT_BUS.register((Object)new KeyBindFactory());
        keyArray = new KeyBinding[]{KEY_UTIL};
    }

    public static void init() {
        KeyBindFactory.regist(KEY_UTIL, key -> {
            ItemStack stack;
            EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
            if (key.func_151470_d() && (stack = player.func_184614_ca()) != null && stack.func_77973_b() instanceof IItemUtilKeylistener) {
                ((IItemUtilKeylistener)stack.func_77973_b()).exec(key);
            }
        });
    }

    public static void regist(KeyBinding key, IKey ikey) {
        map.put(key, ikey);
    }

    @SubscribeEvent
    public void ticker(TickEvent.ClientTickEvent e) {
        for (KeyBinding key : keyArray) {
            map.get(key).exec(key);
        }
    }

    static {
        map = new HashMap<KeyBinding, IKey>();
    }

    private static interface IKey {
        public void exec(KeyBinding var1);
    }

    public static interface IItemUtilKeylistener {
        @SideOnly(value=Side.CLIENT)
        public void exec(KeyBinding var1);
    }
}

