/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.core.init;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassFinder {
    private ClassLoader classLoader;

    public ClassFinder() {
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public List<Class<?>> search(String arg) throws Exception {
        return this.findClasses(arg);
    }

    private ClassFinder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private String fileNameToClassName(String name) {
        return name.substring(0, name.length() - ".class".length());
    }

    private String resourceNameToClassName(String resourceName) {
        return this.fileNameToClassName(resourceName).replace('/', '.');
    }

    private boolean isClassFile(String fileName) {
        return fileName.endsWith(".class");
    }

    private String packageNameToResourceName(String packageName) {
        return packageName.replace('.', '/');
    }

    private List<Class<?>> findClasses(String rootPackageName) throws Exception {
        String resourceName = this.packageNameToResourceName(rootPackageName);
        URL url = this.classLoader.getResource(resourceName);
        if (url == null) {
            return new ArrayList();
        }
        String protocol = url.getProtocol();
        if ("file".equals(protocol)) {
            return this.findClassesWithFile(rootPackageName, new File(url.getFile()));
        }
        if ("jar".equals(protocol)) {
            return this.findClassesWithJarFile(rootPackageName, url);
        }
        throw new IllegalArgumentException("Unsupported Class Load Protodol[" + protocol + "]");
    }

    private List<Class<?>> findClassesWithFile(String packageName, File dir) throws Exception {
        ArrayList classes = new ArrayList();
        for (String path : dir.list()) {
            File entry = new File(dir, path);
            if (entry.isFile() && this.isClassFile(entry.getName())) {
                classes.add(this.classLoader.loadClass(packageName + "." + this.fileNameToClassName(entry.getName())));
                continue;
            }
            if (!entry.isDirectory()) continue;
            classes.addAll(this.findClassesWithFile(packageName + "." + entry.getName(), entry));
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Class<?>> findClassesWithJarFile(String rootPackageName, URL jarFileUrl) throws Exception {
        ArrayList classes = new ArrayList();
        JarURLConnection jarUrlConnection = (JarURLConnection)jarFileUrl.openConnection();
        try (JarFile jarFile = null;){
            jarFile = jarUrlConnection.getJarFile();
            Enumeration<JarEntry> jarEnum = jarFile.entries();
            String packageNameAsResourceName = this.packageNameToResourceName(rootPackageName);
            while (jarEnum.hasMoreElements()) {
                JarEntry jarEntry = jarEnum.nextElement();
                if (!jarEntry.getName().startsWith(packageNameAsResourceName) || !this.isClassFile(jarEntry.getName())) continue;
                classes.add(this.classLoader.loadClass(this.resourceNameToClassName(jarEntry.getName())));
            }
        }
        return classes;
    }
}

