/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.core.init;

import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.GameRegistry;
import ruby.bamboo.core.init.BambooData;
import ruby.bamboo.core.init.ClassFinder;
import ruby.bamboo.core.init.EnumCreateTab;
import ruby.bamboo.core.init.SubBlockBase;

public class DataLoader
extends ClassFinder {
    public List<String> init(String packagePath) {
        ArrayList registedList = Lists.newArrayList();
        try {
            for (Class<?> entry : this.search(packagePath)) {
                if (entry.isAnnotationPresent(BambooData.BambooBlock.class)) {
                    this.registBlock(entry, registedList);
                    continue;
                }
                if (!entry.isAnnotationPresent(BambooData.BambooItem.class)) continue;
                this.registItem(entry, registedList);
            }
        }
        catch (Exception e) {
            FMLLog.bigWarning((String)"\u30d6\u30ed\u30c3\u30af\u521d\u671f\u5316\u4f8b\u5916", (Object[])new Object[0]);
            throw new RuntimeException(e);
        }
        return registedList;
    }

    private void registBlock(Class<? extends Block> cls, List<String> registedList) {
        block10: {
            try {
                FMLLog.info((String)(cls.getName() + " to Loading"), (Object[])new Object[0]);
                Class<?> c = Class.forName(cls.getName());
                Block instance = null;
                BambooData.BambooBlock anoData = cls.getAnnotation(BambooData.BambooBlock.class);
                if (anoData.subblock() == SubBlockBase.class) {
                    String name;
                    try {
                        Constructor<?> cnst = c.getDeclaredConstructor(Material.class);
                        cnst.setAccessible(true);
                        instance = (Block)cnst.newInstance(anoData.material().MATERIAL);
                    }
                    catch (NoSuchMethodException e) {
                        instance = (Block)c.newInstance();
                    }
                    String string = name = anoData.name().isEmpty() ? cls.getSimpleName().toLowerCase() : anoData.name().toLowerCase();
                    if (anoData.createiveTabs() != EnumCreateTab.NONE) {
                        instance.func_149647_a(anoData.createiveTabs().getTabInstance());
                    }
                    instance.func_149663_c(name);
                    GameRegistry.registerBlock((Block)instance, anoData.itemBlock(), (String)name);
                    FMLLog.info((String)"BLOCK: %s to Registed", (Object[])new Object[]{name});
                    registedList.add("bamboomod:" + name);
                    break block10;
                }
                for (SubBlockBase subBlockBase : anoData.subblock().newInstance().getList()) {
                    try {
                        Constructor<?> cnst = c.getDeclaredConstructor(anoData.subblock());
                        cnst.setAccessible(true);
                        instance = (Block)cnst.newInstance(anoData.subblock().cast(subBlockBase));
                    }
                    catch (NoSuchMethodException e) {
                        Constructor<?> cnst = c.getDeclaredConstructor(SubBlockBase.class);
                        cnst.setAccessible(true);
                        instance = (Block)cnst.newInstance(subBlockBase);
                    }
                    String name = instance.func_149739_a().substring(5);
                    if (anoData.createiveTabs() != EnumCreateTab.NONE) {
                        instance.func_149647_a(anoData.createiveTabs().getTabInstance());
                    }
                    GameRegistry.registerBlock((Block)instance, anoData.itemBlock(), (String)name);
                    FMLLog.info((String)"BLOCK: %s to Registed", (Object[])new Object[]{name});
                    registedList.add("bamboomod:" + name);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void registItem(Class<? extends Item> cls, List<String> registedList) {
        try {
            String name;
            FMLLog.info((String)(cls.getName() + " to Loading"), (Object[])new Object[0]);
            Class<?> c = Class.forName(cls.getName());
            Item instance = (Item)c.newInstance();
            BambooData.BambooItem anoData = cls.getAnnotation(BambooData.BambooItem.class);
            String string = name = anoData.name().isEmpty() ? cls.getSimpleName().toLowerCase() : anoData.name().toLowerCase();
            if (anoData.createiveTabs() != EnumCreateTab.NONE) {
                instance.func_77637_a(anoData.createiveTabs().getTabInstance());
            }
            instance.func_77655_b(name);
            GameRegistry.registerItem((Item)instance, (String)name);
            FMLLog.info((String)"ITEM: %s to Registed", (Object[])new Object[]{name});
            registedList.add("bamboomod:" + name);
        }
        catch (Exception e) {
            FMLLog.warning((String)("\u30a2\u30a4\u30c6\u30e0\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u767b\u9332\u4f8b\u5916:" + cls.getName()), (Object[])new Object[0]);
            e.printStackTrace();
        }
    }
}

