/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.core.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StringStateMap
extends StateMapperBase {
    private final String name;
    private final String suffix;
    private final List<IProperty<?>> ignored;

    private StringStateMap(String name, @Nullable String suffix, List<IProperty<?>> ignored) {
        this.name = name;
        this.suffix = suffix;
        this.ignored = ignored;
    }

    protected ModelResourceLocation func_178132_a(IBlockState state) {
        LinkedHashMap map = Maps.newLinkedHashMap((Map)state.func_177228_b());
        String s = this.name;
        if (this.suffix != null) {
            s = s + this.suffix;
        }
        for (IProperty<?> iproperty : this.ignored) {
            map.remove(iproperty);
        }
        return new ModelResourceLocation(s, this.func_178131_a(map));
    }

    @SideOnly(value=Side.CLIENT)
    public static class Builder {
        private String name;
        private String suffix;
        private final List<IProperty<?>> ignored = Lists.newArrayList();

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withSuffix(String builderSuffixIn) {
            this.suffix = builderSuffixIn;
            return this;
        }

        public Builder ignore(IProperty<?> ... p_178442_1_) {
            Collections.addAll(this.ignored, p_178442_1_);
            return this;
        }

        public StringStateMap build() {
            return new StringStateMap(this.name, this.suffix, this.ignored);
        }
    }
}

