/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.crafting;

import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import ruby.bamboo.api.BambooBlocks;
import ruby.bamboo.api.BambooItems;
import ruby.bamboo.api.crafting.RecipeWrapper;
import ruby.bamboo.block.IndLight;
import ruby.bamboo.block.decoration.EnumDecoration;
import ruby.bamboo.crafting.CookingManager;
import ruby.bamboo.crafting.GrindManager;
import ruby.bamboo.entity.EnumSlideDoor;
import ruby.bamboo.item.arrow.AntiArrow;

public class BambooRecipes {
    private int WILD = Short.MAX_VALUE;
    public final String bamboo = "bamboo";
    public final String tudura = "tudura";
    public final String plankWood = "plankWood";
    public final String cooked_rice = "cookedRice";
    public final String busket = "bambooBasket";
    public final String crop_rice = "cropRice";
    public final String log_sakura = "logCherry";
    public final String crop_straw = "cropStraw";
    public final String natto = "natto";
    public final String zunda = "zunda";
    public final String soy_beans = "soybeans";
    public final String red_beans = "redbeans";
    public final String mochi = "mochi";
    public final String cooled_mochi = "cookedMochi";
    public final String flour = "foodFlour";
    public final String dough = "foodDough";
    public final String tofu_kinu = "tofuKinu";
    public final String men = "foodNoodle";
    public final String seaweed = "foodSeaweed";
    public final String tomato = "foodTomato";

    public void addRecipes() {
        this.oreDicRegist();
        this.craftingTableRecipes();
        this.addCookingRecipe();
        this.smeltingRecipes();
        this.registFuel();
        this.registSeed();
        this.addGrindRecipe();
        this.addSmelting();
    }

    public void oreDicRegist() {
        OreDictionary.registerOre((String)"logWood", (ItemStack)this.getIS((Block)BambooBlocks.SAKURA_LOG));
        OreDictionary.registerOre((String)"plankWood", (ItemStack)this.getIS(BambooBlocks.SAKURA_PLANKS));
        OreDictionary.registerOre((String)"bamboo", (ItemStack)this.getIS((Block)BambooBlocks.BAMBOO));
        OreDictionary.registerOre((String)"tudura", (ItemStack)this.getIS(BambooItems.TUDURA));
        OreDictionary.registerOre((String)"cropStraw", (ItemStack)this.getIS(BambooItems.STRAW));
        OreDictionary.registerOre((String)"cropRice", (ItemStack)this.getIS(BambooItems.RAWRICE));
        OreDictionary.registerOre((String)"rice", (ItemStack)this.getIS(BambooItems.RAWRICE));
        OreDictionary.registerOre((String)"cookedRice", (ItemStack)this.getIS(BambooItems.BAMBOO_FOOD, 1, 0));
    }

    public void craftingTableRecipes() {
        this.addShapelessRecipe(this.getIS(BambooBlocks.SAKURA_PLANKS, 4, 0), this.getIS((Block)BambooBlocks.SAKURA_LOG, 1, this.WILD));
        this.addShapelessRecipe(this.getIS(BambooItems.SACK), this.getIS(BambooItems.SACK, 1, this.WILD));
        this.addRecipe(this.getIS(BambooItems.TUDURA), " B ", "B B", " B ", Character.valueOf('B'), "bamboo");
        this.addRecipe(this.getIS(BambooItems.FOLDING_FAN), "PPB", "PPB", "BBB", Character.valueOf('P'), Items.field_151121_aF, Character.valueOf('B'), "bamboo");
        this.addRecipe(this.getIS(BambooItems.SACK), "SSS", "WTW", "WWW", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('T'), "tudura", Character.valueOf('W'), this.getIS(Blocks.field_150325_L, 1, this.WILD));
        this.addCircleRecipe(this.getIS(BambooBlocks.JPCHEST), "tudura", "logWood");
        this.addRecipe(this.getIS(BambooBlocks.TATAMI), " S ", "STS", " S ", Character.valueOf('S'), "cropStraw", Character.valueOf('T'), "tudura");
        this.addRecipe(this.getIS(BambooItems.ITEM_SLIDE_DOOR, 2, EnumSlideDoor.HUSUMA.getId()), "XYX", "X#X", "XYX", Character.valueOf('X'), Items.field_151055_y, Character.valueOf('Y'), Items.field_151121_aF, Character.valueOf('#'), "tudura");
        this.addRecipe(this.getIS(BambooItems.ITEM_SLIDE_DOOR, 2, EnumSlideDoor.SHOZI.getId()), "XYX", "Y#Y", "XYX", Character.valueOf('#'), "tudura", Character.valueOf('X'), Items.field_151055_y, Character.valueOf('Y'), Items.field_151121_aF);
        this.addRecipe(this.getIS(BambooItems.ITEM_SLIDE_DOOR, 2, EnumSlideDoor.GLASS.getId()), "XYX", "X#X", "XYX", Character.valueOf('#'), "tudura", Character.valueOf('X'), Blocks.field_150411_aY, Character.valueOf('Y'), Blocks.field_150410_aZ);
        this.addRecipe(this.getIS(BambooItems.ITEM_SLIDE_DOOR, 2, EnumSlideDoor.GGLASS.getId()), "XYX", "X#X", "XYX", Character.valueOf('#'), "tudura", Character.valueOf('X'), Items.field_151055_y, Character.valueOf('Y'), Blocks.field_150410_aZ);
        this.addRecipe(this.getIS(BambooItems.ITEM_SLIDE_DOOR, 2, EnumSlideDoor.YUKI.getId()), "XYX", "X#X", "XZX", Character.valueOf('#'), "tudura", Character.valueOf('X'), Items.field_151055_y, Character.valueOf('Y'), Items.field_151121_aF, Character.valueOf('Z'), Blocks.field_150410_aZ);
        this.addRecipe(this.getIS(BambooItems.ITEM_SLIDE_DOOR, 2, EnumSlideDoor.AMADO.getId()), "XYX", "X#X", "XYX", Character.valueOf('#'), "tudura", Character.valueOf('X'), Items.field_151055_y, Character.valueOf('Y'), "plankWood");
        this.addRecipe(this.getIS(BambooBlocks.KITUNEBI, 6, 0), "XXX", "Y#Y", "XXX", Character.valueOf('X'), "gemLapis", Character.valueOf('Y'), "tudura", Character.valueOf('#'), Blocks.field_150428_aP);
        this.addRecipe(this.getIS(BambooBlocks.KITUNEBI, 6, 0), "XXX", "Y#Y", "XXX", Character.valueOf('X'), Items.field_151079_bi, Character.valueOf('Y'), "tudura", Character.valueOf('#'), Blocks.field_150428_aP);
        this.addRecipe(this.getIS(BambooBlocks.KITUNEBI, 6, 0), "XYX", "X#X", "XYX", Character.valueOf('X'), "gemLapis", Character.valueOf('Y'), "tudura", Character.valueOf('#'), Blocks.field_150428_aP);
        this.addRecipe(this.getIS(BambooBlocks.KITUNEBI, 6, 0), "XYX", "X#X", "XYX", Character.valueOf('X'), Items.field_151079_bi, Character.valueOf('Y'), "tudura", Character.valueOf('#'), Blocks.field_150428_aP);
        this.addRecipe(this.getIS(BambooBlocks.BAMBOO_PANE, 8, 0), "XXX", "XXX", Character.valueOf('X'), "bamboo");
        this.addRecipe(this.getIS(BambooBlocks.BAMBOO_PANE, 8, 1), "XYX", "XYX", Character.valueOf('X'), "bamboo", Character.valueOf('Y'), this.getIS(BambooBlocks.BAMBOO_PANE, 8, 0));
        this.addRecipe(this.getIS(BambooBlocks.BAMBOO_PANE, 8, 2), "XYX", "XYX", Character.valueOf('X'), "bamboo", Character.valueOf('Y'), this.getIS(BambooBlocks.BAMBOO_PANE, 8, 1));
        this.addRecipe(this.getIS(BambooBlocks.BAMBOO_PANE, 8, 3), "XYX", "XXX", Character.valueOf('X'), "plankWood", Character.valueOf('Y'), "tudura");
        this.addRecipe(this.getIS(BambooBlocks.SPRING_BLOCK), "X#X", "XYX", "XZX", Character.valueOf('X'), Blocks.field_150347_e, Character.valueOf('#'), BambooItems.TUDURA, Character.valueOf('Y'), Items.field_151131_as, Character.valueOf('Z'), Items.field_151129_at);
        this.addRecipe(this.getIS(BambooBlocks.CAMPFIRE), " # ", "XYX", "ZZZ", Character.valueOf('X'), Blocks.field_150411_aY, Character.valueOf('#'), BambooItems.TUDURA, Character.valueOf('Y'), Items.field_151033_d, Character.valueOf('Z'), this.getIS(Items.field_151044_h, 1, 1));
        this.addRecipe(this.getIS(BambooBlocks.ANDON, 1, 0), "###", "#Y#", "#X#", Character.valueOf('#'), Items.field_151055_y, Character.valueOf('X'), Blocks.field_150478_aa, Character.valueOf('Y'), BambooItems.TUDURA);
        this.addRecipe(this.getIS(BambooBlocks.HUTON, 1, 0), " # ", "XXX", "XXX", Character.valueOf('#'), BambooItems.TUDURA, Character.valueOf('X'), Blocks.field_150325_L);
        this.addRecipe(this.getIS(BambooBlocks.MILLSTONE, 1, 0), "###", "X#X", "###", Character.valueOf('#'), new ItemStack(Blocks.field_150347_e), Character.valueOf('X'), BambooItems.TUDURA);
        this.addCircleRecipe(this.getIS(BambooBlocks.KAWARA, 8, 0), "tudura", Items.field_151118_aC);
        this.addCircleRecipe(this.getIS(BambooBlocks.PLASTER, 8, 0), "tudura", Blocks.field_150354_m);
        this.addAltCircleRecipe(this.getIS(BambooBlocks.NAMAKO, 8, 0), "tudura", this.getIS(BambooBlocks.PLASTER), this.getIS(BambooBlocks.KAWARA));
        this.addRecipe(this.getIS(BambooBlocks.WARA, 4, 0), "XXX", "XXX", "XXX", Character.valueOf('X'), this.getIS(BambooItems.STRAW));
        this.addCircleRecipe(this.getIS(BambooBlocks.KAYA, 8, 0), "tudura", "cropWheat");
        this.addCircleRecipe(this.getIS(BambooBlocks.CBIRCH, 8, 0), "tudura", new ItemStack(Blocks.field_150344_f, 1, BlockPlanks.EnumType.BIRCH.func_176839_a()));
        this.addCircleRecipe(this.getIS(BambooBlocks.COAK, 8, 0), "tudura", new ItemStack(Blocks.field_150344_f, 1, BlockPlanks.EnumType.OAK.func_176839_a()));
        this.addCircleRecipe(this.getIS(BambooBlocks.CPINE, 8, 0), "tudura", new ItemStack(Blocks.field_150344_f, 1, BlockPlanks.EnumType.SPRUCE.func_176839_a()));
        this.registerDeco();
        this.addRecipe(this.getIS(BambooItems.BAMBOO_BOW), " BS", "T S", " BS", Character.valueOf('B'), "bamboo", Character.valueOf('T'), "tudura", Character.valueOf('S'), Items.field_151007_F);
        this.addRecipe(this.getIS(BambooItems.BAMBOO_ARROW, 8, 0), "B", "T", "T", Character.valueOf('B'), "bamboo", Character.valueOf('T'), "tudura");
        this.addAntiArrowsRecipe(AntiArrow.AntiType.UNDEAD, 4, Items.field_151078_bh);
        this.addAntiArrowsRecipe(AntiArrow.AntiType.MUTANT, 8, Items.field_151016_H);
        this.addAntiArrowsRecipe(AntiArrow.AntiType.ENDERMAN, 8, Items.field_151079_bi);
        this.addAntiArrowsRecipe(AntiArrow.AntiType.FLAME, 8, Items.field_151145_ak);
        this.addAntiArrowsRecipe(AntiArrow.AntiType.AIR, 8, Items.field_151008_G);
        this.addAntiArrowsRecipe(AntiArrow.AntiType.MULTILEG, 8, Items.field_151007_F);
        this.addAntiArrowsRecipe(AntiArrow.AntiType.HUMAN, 8, Items.field_151166_bC);
        this.addAntiArrowsRecipe(AntiArrow.AntiType.NONLEG, 8, Items.field_151072_bj);
        this.addAntiArrowsRecipe(AntiArrow.AntiType.HARD, 16, Items.field_151042_j);
        this.addAntiArrowsRecipe(AntiArrow.AntiType.SOFT, 8, Items.field_151123_aH);
        this.addAntiArrowsRecipe(AntiArrow.AntiType.WATER, 8, Items.field_151115_aP);
        this.addShapelessRecipe(this.getIS(BambooItems.TORCH_ARROW), this.getIS(BambooItems.BAMBOO_ARROW), Blocks.field_150478_aa);
        this.addShapelessRecipe(this.getIS(BambooItems.LIGHT_ARROW), this.getIS(BambooItems.BAMBOO_ARROW), Items.field_151008_G);
        this.addShapelessRecipe(this.getIS(BambooItems.EXPLODE_ARROW), this.getIS(BambooItems.BAMBOO_ARROW), Items.field_151016_H);
        this.addRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 2, 22), "##", "##", Character.valueOf('#'), "cookedRice");
    }

    public void addCookingRecipe() {
        Block[] indlights;
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 1), Items.field_151082_bd, "cropRice");
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 2), Items.field_151147_al, "cropRice");
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 3), Blocks.field_150338_P, "cropRice");
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 2, 4), Items.field_151147_al, BambooBlocks.BAMBOO);
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 2, 5), Items.field_151082_bd, BambooBlocks.BAMBOO);
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 6), BambooBlocks.BAMBOOSHOOT, "cropRice");
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 7), Items.field_151110_aK, "cropRice");
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 8), Items.field_151110_aK, Items.field_151076_bf, "cropRice");
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 9), this.getIS(Items.field_151115_aP, 1, 0), "cropRice");
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 2, 10), Items.field_151076_bf, BambooBlocks.BAMBOO);
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 11), "cropRice", "foodSeaweed");
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 12), "cropRice", "foodSeaweed", this.getIS(Items.field_151115_aP, 1, 1));
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 13), "cropRice", "foodSeaweed", this.getIS(Items.field_151115_aP, 1, 0), Items.field_151110_aK);
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 14), "cropRice", "foodSeaweed", Blocks.field_150338_P);
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 15), "cropRice", "foodSeaweed", BambooBlocks.BAMBOOSHOOT);
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 16), "cropRice", "foodSeaweed", "foodSeaweed");
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 17), this.getIS(BambooItems.BAMBOO_FOOD, 1, 22), BambooBlocks.BAMBOO, Items.field_151102_aT, Items.field_151102_aT, "soybeans");
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 18), this.getIS(BambooItems.BAMBOO_FOOD, 1, 22), BambooBlocks.BAMBOO, Items.field_151102_aT, "redbeans");
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 19), this.getIS(BambooItems.BAMBOO_FOOD, 1, 22), BambooBlocks.BAMBOO, Items.field_151102_aT, Items.field_151102_aT);
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 20), this.getIS(BambooItems.BAMBOO_FOOD, 1, 22), BambooBlocks.BAMBOO, Items.field_151102_aT, this.getIS((Block)BambooBlocks.SAKURA_LEAVE, 1, this.WILD), this.getIS((Block)Blocks.field_150329_H, 1, this.WILD));
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 21), this.getIS(BambooItems.BAMBOO_FOOD, 1, 22), BambooBlocks.BAMBOO, Items.field_151102_aT, "zunda", "zunda");
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 24), this.getIS(BambooItems.BAMBOO_FOOD, 1, 22), Items.field_151102_aT, Items.field_151102_aT, "soybeans");
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 25), this.getIS(BambooItems.BAMBOO_FOOD, 1, 22), Items.field_151102_aT, "redbeans");
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 26), this.getIS(BambooItems.BAMBOO_FOOD, 1, 22), Items.field_151102_aT, "zunda", "zunda");
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 27), "cropStraw", "soybeans");
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 28), "cropStraw", "soybeans", "cropRice");
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 29), "cropStraw", "soybeans", "cropRice", Items.field_151110_aK);
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 30), this.getIS(BambooItems.BAMBOO_FOOD, 1, 22), this.getIS((Block)BambooBlocks.SAKURA_LEAVE, 1, this.WILD));
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 31), Items.field_151082_bd, "cropRice", Items.field_151110_aK);
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 32), Items.field_151147_al, "cropRice", Items.field_151110_aK);
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 33), "cropRice", "redbeans");
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 34), "cropRice", "redbeans", "foodSeaweed");
        CookingManager.addShapelessRecipe(this.getIS(Items.field_151158_bO, 2), "foodDough", Items.field_151102_aT, Blocks.field_150423_aK);
        CookingManager.addShapelessRecipe(this.getIS(Items.field_151105_aU, 2, 0), "foodDough", Items.field_151102_aT, Items.field_151117_aB);
        CookingManager.addShapelessRecipe(this.getIS(Items.field_151106_aX, 4), "foodDough", Items.field_151102_aT, this.getIS(Items.field_151100_aR, 1, 3));
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 35), "soybeans", Items.field_151131_as);
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 36), "tofuKinu", "foodFlour");
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 38), "foodNoodle", "soybeans", Items.field_151131_as, Items.field_151115_aP);
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 39), "foodNoodle", "soybeans", Items.field_151131_as, Items.field_151115_aP, Items.field_151110_aK);
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 40), "foodNoodle", "soybeans", Items.field_151131_as, Items.field_151115_aP, Items.field_151110_aK, "foodSeaweed", Items.field_151147_al);
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 41), "foodDough", "foodTomato", Items.field_151117_aB, Items.field_151147_al);
        CookingManager.addShapelessRecipe(this.getIS(BambooItems.BAMBOO_FOOD, 1, 42), this.getIS(Items.field_151115_aP, 1, 1), "cropRice");
        CookingManager.addRecipe(new RecipeWrapper((IRecipe)new ShapedOreRecipe(this.getIS(Items.field_151045_i), new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), this.getIS(Items.field_151044_h, 1, 0)})).setFuelCost(101200).setTotalCookTime(1200));
        for (Block indlight : indlights = new Block[]{BambooBlocks.INDLIGHT_WHITE, BambooBlocks.INDLIGHT_ORANGE, BambooBlocks.INDLIGHT_MAGENTA, BambooBlocks.INDLIGHT_LIGHT_BLUE, BambooBlocks.INDLIGHT_YELLOW, BambooBlocks.INDLIGHT_LIME, BambooBlocks.INDLIGHT_PINK, BambooBlocks.INDLIGHT_GRAY, BambooBlocks.INDLIGHT_SILVER, BambooBlocks.INDLIGHT_CYAN, BambooBlocks.INDLIGHT_PURPLE, BambooBlocks.INDLIGHT_BLUE, BambooBlocks.INDLIGHT_BROWN, BambooBlocks.INDLIGHT_GREEN, BambooBlocks.INDLIGHT_RED, BambooBlocks.INDLIGHT_BLACK}) {
            CookingManager.addShapedRecipe(this.getIS(indlight, 12, 0), "XXX", "XYX", "XXX", Character.valueOf('X'), this.getIS((Block)Blocks.field_150399_cn, 1, ((IndLight)indlight).color.func_176765_a()), Character.valueOf('Y'), Items.field_151114_aO);
        }
    }

    public void addGrindRecipe() {
        GrindManager.addRecipe(this.getIS(Blocks.field_150351_n), this.getIS((Block)Blocks.field_150354_m), this.getIS(Blocks.field_150348_b, 0), 0.2f);
        GrindManager.addRecipe(this.getIS(Blocks.field_150351_n), this.getIS((Block)Blocks.field_150354_m), Blocks.field_150347_e, 0.1f);
        GrindManager.addRecipe(this.getIS((Block)Blocks.field_150354_m), this.getIS(Items.field_151145_ak), Blocks.field_150351_n, 0.14f);
        GrindManager.addRecipe(this.getIS(Items.field_151100_aR, 3, 15), this.getIS(Items.field_151100_aR, 2, 15), Items.field_151103_aS, 0.5f);
        GrindManager.addRecipe(this.getIS(Items.field_151065_br, 2, 0), this.getIS(Items.field_151065_br, 1, 0), Items.field_151072_bj, 0.5f);
        GrindManager.addRecipe(this.getIS(BambooItems.RAWRICE, 1, 0), this.getIS(BambooItems.RICE_SEED, 4, 0));
        GrindManager.addRecipe(this.getIS((Block)Blocks.field_150354_m, 4, 0), this.getIS(Blocks.field_150322_A, 1, 0));
        GrindManager.addRecipe(this.getIS(Items.field_151100_aR, 1, 2), this.getIS((Block)Blocks.field_150362_t, 4, Short.MAX_VALUE));
    }

    public void addSmelting() {
        GameRegistry.addSmelting((Block)BambooBlocks.SAKURA_LOG, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
        GameRegistry.addSmelting((Item)BambooItems.RAWRICE, (ItemStack)new ItemStack(BambooItems.BAMBOO_FOOD, 1, 0), (float)0.15f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BambooItems.BAMBOO_FOOD, 2, 22), (ItemStack)new ItemStack(BambooItems.BAMBOO_FOOD, 2, 23), (float)0.15f);
    }

    private void addAntiArrowsRecipe(AntiArrow.AntiType type, int ammo, Object material) {
        this.addRecipe(this.getIS(BambooItems.ANTI_ARROW, ammo, (int)type.getID()), " B ", " T ", "MTM", Character.valueOf('B'), "bamboo", Character.valueOf('T'), "tudura", Character.valueOf('M'), material);
    }

    private void registerDeco() {
        for (EnumDecoration deco : EnumDecoration.values()) {
            if (deco.isHalf()) {
                this.addSlabRecipe(this.getBlockIS(deco.getModName() + "_slab", 6, 0), this.getBlockIS(deco.getModName(), 1, 0));
            }
            if (!deco.isStair()) continue;
            this.addStairsRecipe(this.getBlockIS(deco.getModName() + "_stairs", 4, 0), this.getBlockIS(deco.getModName(), 1, 0));
        }
    }

    public void smeltingRecipes() {
        GameRegistry.addSmelting((ItemStack)this.getIS((Block)BambooBlocks.SAKURA_LOG), (ItemStack)this.getIS(Items.field_151044_h, 1, 1), (float)0.2f);
    }

    public void registFuel() {
        IFuelHandler handler = new IFuelHandler(){
            private Item sakuraLog = Item.func_150898_a((Block)BambooBlocks.SAKURA_LOG);

            public int getBurnTime(ItemStack fuel) {
                if (fuel.func_77973_b() == this.sakuraLog) {
                    return 270;
                }
                return 0;
            }
        };
        GameRegistry.registerFuelHandler((IFuelHandler)handler);
    }

    public void registSeed() {
        MinecraftForge.addGrassSeed((ItemStack)this.getIS(BambooItems.RICE_SEED), (int)10);
    }

    private void addCircleRecipe(ItemStack out, Object center, Object outer) {
        this.addRecipe(out, "XXX", "X#X", "XXX", Character.valueOf('#'), center, Character.valueOf('X'), outer);
    }

    private void addAltCircleRecipe(ItemStack out, Object center, Object one, Object two) {
        this.addRecipe(out, "XYX", "Y#Y", "XYX", Character.valueOf('#'), center, Character.valueOf('X'), one, Character.valueOf('Y'), two);
    }

    private void addSlabRecipe(ItemStack out, ItemStack itemStack) {
        this.addRecipe(out, "XXX", Character.valueOf('X'), itemStack);
        this.addRecipe(new ItemStack(itemStack.func_77973_b(), 1, 0), "X", "X", Character.valueOf('X'), out);
    }

    private void addStairsRecipe(ItemStack out, Object material) {
        this.addRecipe(out, "X  ", "XX ", "XXX", Character.valueOf('X'), material);
        this.addRecipe(out, "  X", " XX", "XXX", Character.valueOf('X'), material);
    }

    private void addRecipe(ItemStack output, Object ... params) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(output, params));
    }

    private void addShapelessRecipe(Object ... objArray) {
        Object[] params = new Object[objArray.length - 1];
        ItemStack output = (ItemStack)objArray[0];
        for (int i = 1; i < objArray.length; ++i) {
            params[i - 1] = objArray[i];
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(output, params));
    }

    private ItemStack getIS(Block block) {
        return this.getIS(block, 0);
    }

    private ItemStack getIS(Block block, int meta) {
        return this.getIS(block, 1, meta);
    }

    private ItemStack getIS(Block block, int amo, int meta) {
        return new ItemStack(block, amo, meta);
    }

    private ItemStack getIS(Item item) {
        return this.getIS(item, 0);
    }

    private ItemStack getIS(Item item, int meta) {
        return this.getIS(item, 1, meta);
    }

    private ItemStack getIS(Item item, int amo, int meta) {
        return new ItemStack(item, amo, meta);
    }

    private ItemStack getBlockIS(String name) {
        return this.getBlockIS(name, 1, 0);
    }

    private ItemStack getBlockIS(String name, int amo, int meta) {
        return new ItemStack(Block.func_149684_b((String)name), amo, meta);
    }

    private ItemStack getItemIS(String name, int amo, int meta) {
        return new ItemStack(Item.func_111206_d((String)name), amo, meta);
    }
}

