/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.crafting;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.oredict.OreDictionary;
import ruby.bamboo.api.crafting.grind.GrindInputItem;
import ruby.bamboo.api.crafting.grind.GrindInputOreItem;
import ruby.bamboo.api.crafting.grind.GrindRecipe;
import ruby.bamboo.api.crafting.grind.IGrindInputItem;
import ruby.bamboo.api.crafting.grind.IGrindRecipe;

public class GrindManager {
    private static final HashMap<IGrindInputItem, IGrindRecipe> recipeMap = new HashMap();

    private GrindManager() {
    }

    public static void addRecipe(ItemStack output, Block input) {
        GrindManager.addRecipe(output, null, new ItemStack(input), 0.0f);
    }

    public static void addRecipe(ItemStack output, Item input) {
        GrindManager.addRecipe(output, null, new ItemStack(input), 0.0f);
    }

    public static void addRecipe(ItemStack output, ItemStack bonus, Block input, float bonusWeight) {
        GrindManager.addRecipe(output, bonus, new ItemStack(input), bonusWeight);
    }

    public static void addRecipe(ItemStack output, ItemStack bonus, Item input, float bonusWeight) {
        GrindManager.addRecipe(output, bonus, new ItemStack(input), bonusWeight);
    }

    public static void addRecipe(ItemStack output, ItemStack input) {
        GrindManager.addRecipe(output, null, input, 0.0f);
    }

    public static void addRecipe(ItemStack output, ItemStack bonus, ItemStack input, float bonusWeight) {
        if (output != null && input != null) {
            GrindInputItem iInput = new GrindInputItem(input);
            if (bonus != null) {
                GrindManager.addRecipe(new GrindRecipe(iInput, output, bonus, bonusWeight));
            } else {
                GrindManager.addRecipe(new GrindRecipe(iInput, output, null, bonusWeight));
            }
        } else {
            FMLLog.warning((String)("Grinding recipe wrong: out:" + output + " in:" + input), (Object[])new Object[0]);
        }
    }

    public static void addRecipe(ItemStack output, ItemStack bonus, String inputOreName, int inputStack, float bonusWeight) {
        if (output != null && inputOreName != null && !OreDictionary.getOres((String)inputOreName).isEmpty()) {
            GrindInputOreItem iInput = new GrindInputOreItem(inputOreName, inputStack);
            if (bonus != null) {
                GrindManager.addRecipe(new GrindRecipe(iInput, output, bonus, bonusWeight));
            } else {
                GrindManager.addRecipe(new GrindRecipe(iInput, output, null, bonusWeight));
            }
        } else {
            FMLLog.warning((String)("Grinding recipe wrong: out:" + output + " in:" + inputOreName), (Object[])new Object[0]);
        }
    }

    public static void addRecipe(IGrindRecipe iRecipe) {
        if (recipeMap.containsKey(iRecipe.getInput())) {
            FMLLog.warning((String)("Grinding recipe registered: " + iRecipe.getInput()), (Object[])new Object[0]);
            return;
        }
        recipeMap.put(iRecipe.getInput(), iRecipe);
    }

    public static IGrindRecipe getOutput(ItemStack input) {
        int[] oreIds = OreDictionary.getOreIDs((ItemStack)input);
        IGrindInputItem iInput = new GrindInputItem(input);
        if (recipeMap.containsKey(iInput)) {
            return GrindManager.getResult(recipeMap.get(iInput), iInput);
        }
        ItemStack inputWild = input.func_77946_l();
        inputWild.func_77964_b(Short.MAX_VALUE);
        iInput = new GrindInputItem(inputWild);
        if (recipeMap.containsKey(iInput)) {
            return GrindManager.getResult(recipeMap.get(iInput), iInput);
        }
        if (0 < oreIds.length) {
            for (int id : oreIds) {
                String oreName = OreDictionary.getOreName((int)id);
                iInput = new GrindInputOreItem(oreName, input.field_77994_a);
                if (!recipeMap.containsKey(iInput)) continue;
                return GrindManager.getResult(recipeMap.get(iInput), iInput);
            }
        }
        return null;
    }

    private static IGrindRecipe getResult(IGrindRecipe recipe, IGrindInputItem iInput) {
        if (recipe.getInput().getStackSize() <= iInput.getStackSize() && (GrindManager.isOreMatch(iInput.getOreIDs(), recipe.getInput().getOreIDs()) || recipe.getInput().equals(iInput))) {
            return recipe;
        }
        return null;
    }

    public static boolean isOreMatch(int[] input, int[] target) {
        Arrays.sort(input);
        for (int t : target) {
            if (0 > Arrays.binarySearch(input, t)) continue;
            return true;
        }
        return false;
    }

    public static Collection<IGrindRecipe> getRecipeList() {
        return recipeMap.values();
    }
}

