/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.enchant;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import ruby.bamboo.enchant.EnchantBase;
import ruby.bamboo.enchant.IBambooEnchantable;
import ruby.bamboo.enchant.event.IBreakEnchant;
import ruby.bamboo.util.BlockDestroyHelper;

public class Chain
extends EnchantBase
implements IBreakEnchant {
    public Chain(int id, String name) {
        super(id, name);
    }

    @Override
    public void onBreakBlock(ItemStack stack, World world, Block block, BlockPos pos, EntityLivingBase player, RayTraceResult rtr) {
        if (!world.field_72995_K && block instanceof BlockOre) {
            int limit = (int)Math.ceil(IBambooEnchantable.getEnchLevel(stack, this, -1) / 15) + 3;
            Set<BlockPos> set = this.getBreakSet(world, pos, block, limit);
            IBambooEnchantable item = (IBambooEnchantable)stack.func_77973_b();
            int exp = (int)(item.getBlockBreakExp(stack, world, block, pos) * (float)set.size());
            item.addExp(stack, exp, 0.5f);
            BlockDestroyHelper.addQueue(player.func_130014_f_(), set);
        }
    }

    private Set<BlockPos> getBreakSet(World world, BlockPos firstPos, Block targetBlock, int limit) {
        List<Object> nextTargets = Lists.newArrayList((Object[])new BlockPos[]{firstPos});
        LinkedHashSet<BlockPos> fouds = new LinkedHashSet<BlockPos>();
        do {
            nextTargets = nextTargets.stream().flatMap(target -> Arrays.stream(EnumFacing.field_82609_l).map(arg_0 -> ((BlockPos)target).func_177972_a(arg_0))).filter(fixedPos -> world.func_180495_p(fixedPos).func_177230_c().equals(targetBlock)).filter(fixedPos -> fouds.size() <= limit && fouds.add((BlockPos)fixedPos)).collect(Collectors.toList());
        } while (fouds.size() <= limit && !nextTargets.isEmpty());
        return fouds;
    }

    @Override
    public int getRarity() {
        return 15;
    }
}

