/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.enchant;

import java.util.Arrays;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import ruby.bamboo.enchant.EnchantBase;
import ruby.bamboo.enchant.event.IAttackEnchant;
import ruby.bamboo.item.arrow.AntiArrow;

public class ElementAttack
extends EnchantBase
implements IAttackEnchant {
    final String[] element = new String[]{"Fire", "Hell", "Poison", "Holy"};

    public ElementAttack(int id, String name) {
        super(id, name);
    }

    @Override
    public void onEntityAttack(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        float dmgSum = 0.0f;
        for (NBTTagCompound nbt : this.getSubTypesToNBT(stack)) {
            short lvl = nbt.func_74765_d("lvl");
            float baseDmg = (float)lvl / 50.0f;
            switch (this.element[ElementAttack.getSubID(nbt.func_74765_d("id")) % this.element.length]) {
                case "Fire": {
                    if (target.func_70045_F()) break;
                    dmgSum += baseDmg / 6.0f;
                    target.func_70015_d((int)Math.ceil(baseDmg));
                    break;
                }
                case "Hell": {
                    if (Arrays.stream(AntiArrow.AntiType.UNDEAD.getEntity()).anyMatch(e -> e.isInstance(target))) break;
                    attacker.func_70691_i((dmgSum += baseDmg / 3.0f) / 2.0f);
                    break;
                }
                case "Poison": {
                    if (target instanceof EntitySpider) break;
                    dmgSum += baseDmg / 5.0f;
                    break;
                }
                case "Holy": {
                    dmgSum += baseDmg / 10.0f;
                    if (!Arrays.stream(AntiArrow.AntiType.UNDEAD.getEntity()).anyMatch(e -> e.isInstance(target))) break;
                    dmgSum += baseDmg / 2.0f;
                }
            }
        }
        target.func_70606_j(target.func_110143_aJ() - dmgSum);
    }

    @Override
    public String[] getSubTypes() {
        return this.element;
    }

    @Override
    public EnchantBase.EnchantType[] getEnchantType() {
        return new EnchantBase.EnchantType[]{EnchantBase.EnchantType.TOOL, EnchantBase.EnchantType.WEAPON};
    }
}

