/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.enchant;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import ruby.bamboo.enchant.IBambooEnchantable;

public abstract class EnchantBase {
    public static final byte SUB_WILD = -1;
    private final short mainId;
    public final String name;

    public EnchantBase(int id, String name) {
        this.mainId = (short)id;
        this.name = name;
    }

    public String getName(ItemStack is, int subType) {
        String[] subTypeStr = this.getSubTypes();
        if (subTypeStr != null && 0 < subTypeStr.length) {
            return this.name + "_" + subTypeStr[subType < subTypeStr.length ? subType : subType % subTypeStr.length];
        }
        return this.name;
    }

    public int getMaxLevel() {
        return 1500;
    }

    public int getEnchantListMaxLevel() {
        return this.getMaxLevel();
    }

    public int getRarity() {
        return 1;
    }

    public final int getEffectId(int subTypeId) {
        return (this.mainId & 0xFF) + ((subTypeId & 0xFF) << 8);
    }

    public static final int getMainID(int joinedId) {
        return joinedId & 0xFF;
    }

    public static final int getSubID(int joinedId) {
        return joinedId >> 8 & 0xFF;
    }

    public List<NBTTagCompound> getSubTypesToNBT(ItemStack stack) {
        return IBambooEnchantable.getSpenchList(stack).stream().filter(e -> EnchantBase.isEqual(this, e.func_74765_d("id"), -1)).collect(Collectors.toList());
    }

    public String[] getSubTypes() {
        return null;
    }

    public int getSubTypeCount() {
        return this.getSubTypes() != null ? this.getSubTypes().length : 0;
    }

    public EnchantType[] getEnchantType() {
        return new EnchantType[]{EnchantType.TOOL};
    }

    public boolean isLevelupEnchant() {
        return true;
    }

    public String toString() {
        return this.name;
    }

    public static boolean isEqual(EnchantBase base, int effectId, int subTypeId) {
        if (subTypeId != -1) {
            return base.getEffectId(subTypeId) == effectId;
        }
        return base.mainId == EnchantBase.getMainID(effectId);
    }

    static enum EnchantType {
        TOOL,
        WEAPON;

    }
}

