/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.enchant;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;
import ruby.bamboo.enchant.Curse;
import ruby.bamboo.enchant.EnchantBase;
import ruby.bamboo.enchant.Entry;
import ruby.bamboo.enchant.IBambooEnchantable;
import ruby.bamboo.enchant.Power;
import ruby.bamboo.enchant.SpecialEnchant;

public class EnchantFactory {
    private static final boolean debug = true;

    public static List<Entry> createViewList(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof IBambooEnchantable)) {
            return ImmutableList.of();
        }
        IBambooEnchantable item = (IBambooEnchantable)stack.func_77973_b();
        int num = (int)(2.0 + Math.ceil((double)IBambooEnchantable.getEnchLevel(stack, SpecialEnchant.getEnchantmentByClass(Power.class), 0) * 0.02) * 3.0);
        return EnchantFactory.getDebugList();
    }

    private static final Entry getRandomEnchant(Random rand) {
        int rarity;
        EnchantBase base;
        int mod;
        String prefix = "";
        int color = 0xFFFFFF;
        rand.nextDouble();
        if (rand.nextFloat() < 0.2f) {
            if (rand.nextFloat() < 0.2f) {
                if (rand.nextFloat() < 0.2f) {
                    mod = 14;
                    color = 0x6C00C6;
                } else {
                    mod = 10;
                    color = 16741376;
                }
                if (rand.nextFloat() < 0.3f) {
                    prefix = "\u00a7k";
                }
            } else {
                mod = 6;
                color = 0xFFFF00;
            }
        } else {
            mod = rand.nextInt(4);
        }
        do {
            base = (EnchantBase)SpecialEnchant.getEnchantList().get(rand.nextInt(SpecialEnchant.getEnchantList().size()));
            rarity = base.getRarity();
        } while (!base.isLevelupEnchant() || (float)(1 / Math.max(rarity - mod, 1)) < rand.nextFloat());
        Entry entry = new Entry(base.getEffectId(rand.nextInt(base.getSubTypeCount() + 1)), IntStream.rangeClosed(1, 1 + mod).map(e -> rand.nextInt(25) + 1 + mod).sum(), rand.nextInt(18) + (int)((double)mod * 0.5) + 3);
        entry.setPrefix(prefix);
        entry.setColor(color);
        return entry;
    }

    public static void setEnchant(ItemStack stack, int num) {
        List<Entry> list = EnchantFactory.getDebugList();
        if (list.size() <= num) {
            return;
        }
        if (stack == null || !(stack.func_77973_b() instanceof IBambooEnchantable)) {
            return;
        }
        IBambooEnchantable item = (IBambooEnchantable)stack.func_77973_b();
        if (!IBambooEnchantable.canLevelUp(stack)) {
            return;
        }
        Entry entry = list.get(num);
        item.addSpecialEnchLevelLevel(stack, entry.getBase(), entry.getSubType(), entry.getAmount());
        if (IBambooEnchantable.getLV(stack) > entry.curseLv) {
            item.addSpecialEnchLevelLevel(stack, SpecialEnchant.getEnchantmentByClass(Curse.class), 0, entry.getAmount());
        }
        item.levelUp(stack);
    }

    private static final List<Entry> getDebugList() {
        ArrayList<Entry> list = new ArrayList<Entry>();
        SpecialEnchant.getEnchantList().stream().forEach(base -> IntStream.rangeClosed(0, Math.max(base.getSubTypeCount() - 1, 0)).forEach(e -> list.add(new Entry(base.getEffectId(e), 300, 100))));
        return list;
    }

    private static /* synthetic */ Entry lambda$createViewList$16(Random rand, Long baseSeed, int e) {
        rand.setSeed(baseSeed + (long)(e << 32));
        return EnchantFactory.getRandomEnchant(rand);
    }
}

