/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.enchant;

import com.google.common.base.Strings;
import net.minecraft.item.ItemStack;
import ruby.bamboo.enchant.EnchantBase;
import ruby.bamboo.enchant.SpecialEnchant;

public class Entry {
    private final short enchantId;
    private final int amount;
    final int curseLv;
    private String preFix;
    private int clolr = 0xFFFFFF;

    public Entry(int enchantId, int amount) {
        this(enchantId, amount, 0);
    }

    public Entry(int enchantId, int amount, int curseLv) {
        this.enchantId = (short)enchantId;
        this.amount = amount;
        this.curseLv = curseLv;
    }

    public short getEnchantId() {
        return this.enchantId;
    }

    public int getMainId() {
        return EnchantBase.getMainID(this.enchantId);
    }

    public int getSubType() {
        return EnchantBase.getSubID(this.enchantId);
    }

    public int getAmount() {
        return this.amount;
    }

    public int getCurseLv() {
        return this.curseLv;
    }

    public EnchantBase getBase() {
        return SpecialEnchant.getEnchantmentById(this.enchantId);
    }

    public String getName(ItemStack stack) {
        return this.getBase().getName(stack, this.getSubType());
    }

    public void setPrefix(String str) {
        this.preFix = str;
    }

    public String getPrefix() {
        return Strings.nullToEmpty((String)this.preFix);
    }

    public int getClolr() {
        return this.clolr;
    }

    public void setColor(int clolr) {
        this.clolr = clolr;
    }
}

