/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.enchant;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ruby.bamboo.core.BambooCore;
import ruby.bamboo.core.PacketDispatcher;
import ruby.bamboo.core.client.KeyBindFactory;
import ruby.bamboo.enchant.EnchantBase;
import ruby.bamboo.enchant.Power;
import ruby.bamboo.enchant.SpecialEnchant;
import ruby.bamboo.packet.MessageBambooUtil;
import ruby.bamboo.util.ItemStackHelper;

public interface IBambooEnchantable
extends KeyBindFactory.IItemUtilKeylistener,
MessageBambooUtil.IMessagelistener {
    public static final NBTTagCompound empty = new NBTTagCompound();

    default public void addExpChance(ItemStack stack, EntityLivingBase target) {
        this.addExpChance(stack, target, 1.0f);
    }

    default public void addExpChance(ItemStack stack, EntityLivingBase target, float rate) {
        this.addExp(stack, (int)this.getEntityAtkExp(stack, target), rate);
    }

    default public float getEntityAtkExp(ItemStack stack, EntityLivingBase target) {
        float exp = 1.0f;
        if (target instanceof EntityMob && target.func_110143_aJ() <= 0.0f) {
            exp = (float)Math.ceil(target.func_110138_aP() * 0.1f);
        }
        return exp;
    }

    default public void addExpChance(ItemStack stack, World worldIn, Block blockIn, BlockPos pos) {
        this.addExpChance(stack, worldIn, blockIn, pos, 1.0f);
    }

    default public void addExpChance(ItemStack stack, World worldIn, Block blockIn, BlockPos pos, float rate) {
        this.addExp(stack, (int)this.getBlockBreakExp(stack, worldIn, blockIn, pos), rate);
    }

    default public float getBlockBreakExp(ItemStack stack, World worldIn, Block blockIn, BlockPos pos) {
        float exp = 1.0f;
        Item dropItem = blockIn.func_180660_a(worldIn.func_180495_p(pos), worldIn.field_73012_v, 0);
        float hardness = blockIn.func_176223_P().func_185887_b(worldIn, pos);
        if (dropItem != null && dropItem != Item.func_150898_a((Block)blockIn)) {
            exp = exp * hardness * 2.0f;
            exp = Math.round(exp);
        } else {
            if (hardness > 1.0f) {
                hardness = 1.0f;
            }
            if (worldIn.field_73012_v.nextFloat() > hardness) {
                exp = 0.0f;
            }
        }
        return exp;
    }

    default public void addExp(ItemStack stack, int num, float rate) {
        int nuwExp;
        int expNum = (int)Math.ceil((float)num * rate);
        nuwExp = expNum + (nuwExp = stack.func_77952_i()) > IBambooEnchantable.getNextExp(stack) ? IBambooEnchantable.getNextExp(stack) : (nuwExp += expNum);
        if (nuwExp < 0) {
            nuwExp = 0;
        }
        stack.func_77964_b(nuwExp);
    }

    public static boolean canLevelUp(ItemStack stack) {
        return true;
    }

    default public void levelUp(ItemStack stack) {
        short[] t = new short[]{100, 2000, 8000, 20000, 32000};
        float[] f = new float[]{1.0f, 1.5f, 2.0f};
        int next = 100;
        stack.func_77964_b(0);
        int lv = IBambooEnchantable.getLV(stack) + 1;
        IBambooEnchantable.setLV(stack, lv);
        next = (int)((float)(next * lv) + (float)t[lv / 3 < t.length ? lv / 3 : 4] * f[lv % 3]);
        if (next > 32000) {
            next = 32000;
        }
        IBambooEnchantable.setNextExp(stack, next);
    }

    public static String getDisplayEnchantStrength(int str) {
        int cnt;
        StringBuilder stb = new StringBuilder("[");
        for (cnt = (int)Math.ceil((double)str / 50.0); 6 <= cnt; cnt -= 6) {
            stb.append("+");
        }
        while (1 <= cnt) {
            stb.append("*");
            --cnt;
        }
        stb.append("]");
        return stb.toString();
    }

    default public String getPrefix(ItemStack stack) {
        return "";
    }

    default public String getSuffix(ItemStack stack) {
        int pow = (int)Math.ceil((float)IBambooEnchantable.getEnchntNBT(stack, SpecialEnchant.getEnchantmentByClass(Power.class), -1).func_74765_d("lvl") / 50.0f);
        return " [LV:" + IBambooEnchantable.getLV(stack) + " Exp:" + (int)(IBambooEnchantable.getExpP(stack) * 100.0f) + "%]" + (pow > 0 ? " +" + pow : "");
    }

    public static float getExpP(ItemStack stack) {
        float f = (float)stack.func_77973_b().getDamage(stack) / (float)IBambooEnchantable.getNextExp(stack);
        return f > 1.0f ? 1.0f : f;
    }

    public static int getLV(ItemStack stack) {
        return IBambooEnchantable.getStatus(stack).func_74762_e("lvl");
    }

    public static void setLV(ItemStack stack, int num) {
        IBambooEnchantable.getStatus(stack).func_74768_a("lvl", num);
    }

    public static int getNextExp(ItemStack stack) {
        return IBambooEnchantable.getStatus(stack).func_74762_e("nextExp");
    }

    public static void setNextExp(ItemStack stack, int num) {
        IBambooEnchantable.getStatus(stack).func_74768_a("nextExp", num);
    }

    public static NBTTagCompound getStatus(ItemStack stack) {
        if (IBambooEnchantable.getNBT(stack).func_74764_b("status")) {
            return IBambooEnchantable.getNBT(stack).func_74775_l("status");
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("lvl", 0);
        nbt.func_74768_a("nextExp", 16);
        IBambooEnchantable.getNBT(stack).func_74782_a("status", (NBTBase)nbt);
        return nbt;
    }

    public static NBTTagCompound getNBT(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt == null ? IBambooEnchantable.createNBT(stack) : nbt;
    }

    public static NBTTagCompound createNBT(ItemStack stack) {
        NBTTagCompound nbttag = new NBTTagCompound();
        stack.func_77982_d(nbttag);
        nbttag.func_74768_a("RepairCost", 40);
        IBambooEnchantable.setLV(stack, 0);
        IBambooEnchantable.setNextExp(stack, 1);
        return nbttag;
    }

    default public void setNomalEnchLevelLevel(ItemStack stack, Enchantment targetEnch, int level) {
        NBTTagList nbttaglist = this.getNBTTagEnchList(stack);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            short enchId = nbttaglist.func_150305_b(i).func_74765_d("id");
            Enchantment ench = Enchantment.func_185262_c((int)enchId);
            if (ench != targetEnch) continue;
            short enchLv = nbttaglist.func_150305_b(i).func_74765_d("lvl");
            if (level > 0) {
                nbttaglist.func_150305_b(i).func_74777_a("lvl", (short)level);
            } else {
                nbttaglist.func_74744_a(i);
            }
            return;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74777_a("id", (short)Enchantment.func_185258_b((Enchantment)targetEnch));
        nbt.func_74777_a("lvl", (short)level);
        nbttaglist.func_74742_a((NBTBase)nbt);
    }

    default public void addSpecialEnchLevelLevel(ItemStack stack, EnchantBase targetEnch, int subTypeId, int addLevel) {
        NBTTagCompound nbt;
        NBTTagList nbttaglist = IBambooEnchantable.getNBTTagSpenchList(stack);
        Iterator ite = ItemStackHelper.getNBTTagListIte(IBambooEnchantable.getNBTTagSpenchList(stack)).iterator();
        while (ite.hasNext()) {
            nbt = (NBTTagCompound)ite.next();
            short enchId = nbt.func_74765_d("id");
            if (enchId != targetEnch.getEffectId(subTypeId)) continue;
            short enchLv = nbt.func_74765_d("lvl");
            if (addLevel > 0) {
                nbt.func_74777_a("lvl", (short)(enchLv + (int)Math.ceil((double)addLevel / 2.0)));
            } else if (enchLv + addLevel > 0) {
                nbt.func_74777_a("lvl", (short)(enchLv - addLevel));
            } else {
                ite.remove();
            }
            return;
        }
        nbt = new NBTTagCompound();
        nbt.func_74777_a("id", (short)targetEnch.getEffectId(subTypeId));
        nbt.func_74777_a("lvl", (short)addLevel);
        nbt.func_74757_a("enable", true);
        nbttaglist.func_74742_a((NBTBase)nbt);
    }

    default public NBTTagList getNBTTagEnchList(ItemStack stack) {
        if (!stack.func_77978_p().func_150297_b("ench", 9)) {
            stack.func_77978_p().func_74782_a("ench", (NBTBase)new NBTTagList());
        }
        return stack.func_77978_p().func_150295_c("ench", 10);
    }

    public static NBTTagList getNBTTagSpenchList(ItemStack stack) {
        if (!stack.func_77978_p().func_150297_b("spench", 9)) {
            stack.func_77978_p().func_74782_a("spench", (NBTBase)new NBTTagList());
        }
        return stack.func_77978_p().func_150295_c("spench", 10);
    }

    public static List<NBTTagCompound> getSpenchList(ItemStack stack) {
        return ImmutableList.copyOf(ItemStackHelper.getNBTTagListIte(IBambooEnchantable.getNBTTagSpenchList(stack)));
    }

    public static NBTTagCompound getEnchntNBT(ItemStack stack, EnchantBase base, int subTypeId) {
        if (stack.func_77973_b() instanceof IBambooEnchantable) {
            IBambooEnchantable item = (IBambooEnchantable)stack.func_77973_b();
            NBTTagList nbttaglist = IBambooEnchantable.getNBTTagSpenchList(stack);
            for (NBTTagCompound tag : ItemStackHelper.getNBTTagListIte(nbttaglist)) {
                short enchId = tag.func_74765_d("id");
                if (!EnchantBase.isEqual(base, enchId, subTypeId)) continue;
                return tag;
            }
        }
        return empty;
    }

    public static short getEnchLevel(ItemStack stack, EnchantBase base, int subTypeId) {
        if (stack == null || base == null) {
            return 0;
        }
        NBTTagCompound nbt = IBambooEnchantable.getEnchntNBT(stack, base, subTypeId);
        return nbt != null ? nbt.func_74765_d("lvl") : (short)0;
    }

    public static boolean isEnchantEnable(ItemStack stack, EnchantBase base, int subTypeId) {
        NBTTagCompound nbt = IBambooEnchantable.getEnchntNBT(stack, base, subTypeId);
        return nbt != null ? nbt.func_74767_n("enable") : false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    default public void exec(KeyBinding key) {
        EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
        if (key.func_151468_f()) {
            player.openGui((Object)BambooCore.instance, 4, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            PacketDispatcher.sendToServer(new MessageBambooUtil());
        }
    }

    @Override
    default public void call(EntityPlayer player, ItemStack is, byte data) {
        player.openGui((Object)BambooCore.instance, 4, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
    }

    public static Long getRandSeed(ItemStack stack) {
        return stack.func_82833_r().hashCode();
    }
}

