/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.enchant;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import ruby.bamboo.core.init.ClassFinder;
import ruby.bamboo.enchant.Ability;
import ruby.bamboo.enchant.Chain;
import ruby.bamboo.enchant.Curse;
import ruby.bamboo.enchant.Efficiency;
import ruby.bamboo.enchant.ElementAttack;
import ruby.bamboo.enchant.ElementDefense;
import ruby.bamboo.enchant.EnchantBase;
import ruby.bamboo.enchant.Extender;
import ruby.bamboo.enchant.ExtraTool;
import ruby.bamboo.enchant.Floating;
import ruby.bamboo.enchant.Food;
import ruby.bamboo.enchant.Fortune;
import ruby.bamboo.enchant.Hate;
import ruby.bamboo.enchant.IBambooEnchantable;
import ruby.bamboo.enchant.Love;
import ruby.bamboo.enchant.Monster;
import ruby.bamboo.enchant.Power;
import ruby.bamboo.enchant.Shears;
import ruby.bamboo.enchant.SilkTouch;
import ruby.bamboo.enchant.Support;
import ruby.bamboo.enchant.Unbreaking;
import ruby.bamboo.enchant.event.IAttackEnchant;
import ruby.bamboo.enchant.event.IBreakEnchant;
import ruby.bamboo.enchant.event.ITickableEnchant;

public class SpecialEnchant {
    private static final Map<Integer, EnchantBase> baseMap;
    private static final Multimap<Class<?>, EnchantBase> ifMap;

    public static String getEnchantmentName(ItemStack stack, short enchId) {
        return SpecialEnchant.getEnchantmentById(enchId).getName(stack, EnchantBase.getSubID(enchId));
    }

    public static EnchantBase getEnchantmentById(short enchId) {
        return baseMap.get(EnchantBase.getMainID(enchId));
    }

    public static EnchantBase getEnchantmentByClass(Class<? extends EnchantBase> base) {
        return baseMap.values().parallelStream().filter(encha -> encha.getClass() == base).findAny().get();
    }

    public static ImmutableList<EnchantBase> getEnchantList() {
        return ImmutableList.builder().addAll(baseMap.values()).build();
    }

    public static void onBreakBlock(ItemStack stack, World world, Block block, BlockPos pos, EntityLivingBase player, RayTraceResult rtr) {
        SpecialEnchant.getEnchantEnableStream(IBreakEnchant.class, stack).forEach(e -> e.onBreakBlock(stack, world, block, pos, player, rtr));
    }

    public static void onAttackEntity(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        SpecialEnchant.getEnchantEnableStream(IAttackEnchant.class, stack).forEach(e -> e.onEntityAttack(stack, target, attacker));
    }

    public static void onUpdate(ItemStack stack, EntityLivingBase ticker, int itemSlot, boolean isSelected) {
        SpecialEnchant.getEnchantEnableStream(ITickableEnchant.class, stack).forEach(e -> e.onTick(stack, ticker, itemSlot, isSelected));
    }

    private static <T> Stream<T> getEnchantEnableStream(Class<T> cls, ItemStack stack) {
        return ifMap.get(cls).parallelStream().filter(base -> IBambooEnchantable.isEnchantEnable(stack, base, -1));
    }

    static {
        ifMap = ArrayListMultimap.create();
        ArrayList<EnchantBase> enchantList = new ArrayList<EnchantBase>();
        enchantList.add(new Chain(0, "Chain"));
        enchantList.add(new ElementAttack(1, "ElementsAttack"));
        enchantList.add(new Power(2, "Power"));
        enchantList.add(new ElementDefense(3, "ElementDefense"));
        enchantList.add(new ExtraTool(4, "ExTool"));
        enchantList.add(new Floating(5, "Floating"));
        enchantList.add(new Love(6, "Love"));
        enchantList.add(new Shears(7, "Shears"));
        enchantList.add(new Support(8, "Support"));
        enchantList.add(new Food(9, "Food"));
        enchantList.add(new Hate(10, "Hate"));
        enchantList.add(new Efficiency(11, "Efficiency"));
        enchantList.add(new Unbreaking(12, "Unbreaking"));
        enchantList.add(new SilkTouch(13, "SilkTouch"));
        enchantList.add(new Fortune(14, "Fortune"));
        enchantList.add(new Monster(15, "Monster"));
        enchantList.add(new Ability(16, "Ability"));
        enchantList.add(new Extender(17, "Extender"));
        enchantList.add(new Curse(255, "Curse"));
        Object list = ImmutableList.of();
        try {
            list = new ClassFinder().search("ruby.bamboo.enchant.event");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        baseMap = enchantList.stream().collect(Collectors.toMap(base -> base.getEffectId(0), base -> base));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Class c = (Class)iterator.next();
            ifMap.putAll((Object)c, (Iterable)enchantList.parallelStream().filter(c::isInstance).collect(Collectors.toList()));
        }
    }
}

