/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.entity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import ruby.bamboo.api.BambooItems;
import ruby.bamboo.entity.EnumSlideDoor;

public class SlideDoor
extends Entity {
    private byte closeTimer;
    private static final DataParameter<Byte> DIRECTION = EntityDataManager.func_187226_a(SlideDoor.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> ISMIRROR = EntityDataManager.func_187226_a(SlideDoor.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> ISMOVE = EntityDataManager.func_187226_a(SlideDoor.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> DOORID = EntityDataManager.func_187226_a(SlideDoor.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> ISSTOP = EntityDataManager.func_187226_a(SlideDoor.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> MOVEDIR = EntityDataManager.func_187226_a(SlideDoor.class, (DataSerializer)DataSerializers.field_187191_a);
    private static EnumSlideDoor[] tex = EnumSlideDoor.values();

    public SlideDoor(World world) {
        super(world);
        this.func_70105_a(1.0f, 2.0f);
    }

    public boolean shouldRenderInPass(int pass) {
        return this.isBlend() ? pass == 1 : pass == 0;
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, @Nullable ItemStack stack, EnumHand hand) {
        if (player.func_70093_af()) {
            this.setDataisStop(!this.getDataIsStop());
            player.func_184609_a(hand);
            return EnumActionResult.SUCCESS;
        }
        if (this.getDataIsStop()) {
            if (!this.getDataMoveflg()) {
                this.doorOpen((Entity)player);
            } else {
                this.doorClose();
            }
            player.func_184609_a(hand);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public void func_70108_f(Entity entityIn) {
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return null;
    }

    public String getTex() {
        return this.getEnumSlideDoor(this.getDataDoorId()).getTex();
    }

    public void setMirror(boolean b) {
        this.setDataMirror(b);
    }

    public boolean isMirror() {
        return this.getDataMirror();
    }

    public EnumFacing getDir() {
        return this.getDataDir();
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        this.setDataDir(nbttagcompound.func_74771_c("dir"));
        this.setDataMirror(nbttagcompound.func_74767_n("mirror"));
        this.setDataMoveflg(nbttagcompound.func_74767_n("moveflg"));
        this.setDataisStop(nbttagcompound.func_74767_n("isStop"));
        if (nbttagcompound.func_74764_b("doorId")) {
            this.setDataDoorId(nbttagcompound.func_74765_d("doorId"));
        } else if (nbttagcompound.func_74779_i("toptex").indexOf("husuma") != -1) {
            this.setDataDoorId(EnumSlideDoor.HUSUMA.getId());
        } else {
            this.setDataDoorId(EnumSlideDoor.SHOZI.getId());
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74774_a("dir", (byte)this.getDataDir().func_176736_b());
        nbttagcompound.func_74757_a("mirror", this.getDataMirror());
        nbttagcompound.func_74757_a("moveflg", this.getDataMoveflg());
        nbttagcompound.func_74757_a("isStop", this.getDataIsStop());
        nbttagcompound.func_74774_a("doorId", this.getDataDoorId());
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (!(this.field_70170_p.field_72995_K || this.getDataIsStop() || this.field_70128_L)) {
            EntityPlayer entityplayer = null;
            if (par1DamageSource.field_76373_n != "player") {
                return false;
            }
            entityplayer = (EntityPlayer)par1DamageSource.func_76346_g();
            this.func_70106_y();
            if (entityplayer != null && entityplayer.field_71075_bZ.field_75098_d) {
                return true;
            }
            this.dropItem(this.getDataDoorId());
        }
        if (this.getDataIsStop() && par1DamageSource.func_76346_g() != null) {
            double offsetPosX = this.field_70165_t;
            double offsetPosZ = this.field_70161_v;
            switch (par1DamageSource.func_76346_g().func_174811_aO()) {
                case EAST: {
                    offsetPosX += 0.05;
                    break;
                }
                case NORTH: {
                    offsetPosZ -= 0.05;
                    break;
                }
                case SOUTH: {
                    offsetPosZ += 0.05;
                    break;
                }
                case WEST: {
                    offsetPosX -= 0.05;
                    break;
                }
                case UP: {
                    break;
                }
                case DOWN: {
                    break;
                }
            }
            this.func_70107_b(offsetPosX, this.field_70163_u, offsetPosZ);
        }
        return true;
    }

    private void dropItem(short damage) {
        this.func_70099_a(new ItemStack(BambooItems.ITEM_SLIDE_DOOR, 1, (int)damage), 1.0f);
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
        if (!this.getDataIsStop() && !this.getDataMoveflg()) {
            this.doorOpen((Entity)par1EntityPlayer);
        }
        this.closeTimer = (byte)10;
    }

    public void func_70071_h_() {
        List collideEntity;
        if (!this.field_70170_p.field_72995_K && (collideEntity = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0))) != null) {
            for (Entity entity : collideEntity) {
                if (entity.field_70128_L || !(entity instanceof EntityTameable)) continue;
                if (!this.getDataIsStop() && !this.getDataMoveflg()) {
                    this.doorOpen(entity);
                }
                this.closeTimer = (byte)30;
            }
        }
        this.field_70145_X = true;
        if (!this.getDataIsStop()) {
            if (this.closeTimer < 0 && this.getDataMoveflg()) {
                this.doorClose();
            } else {
                this.closeTimer = (byte)(this.closeTimer - 1);
            }
        }
    }

    private void doorOpen(Entity entity) {
        if (!this.getDataMoveflg() && this.isOpendir(entity)) {
            EnumFacing facing = this.getDir();
            if (this.getDataMirror()) {
                facing = facing.func_176734_d();
            }
            switch (facing.func_176740_k()) {
                case X: {
                    this.field_70161_v -= (double)facing.func_176743_c().func_179524_a();
                    this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, 0.0, (double)(-facing.func_176743_c().func_179524_a())));
                    break;
                }
                case Z: {
                    this.field_70165_t += (double)facing.func_176743_c().func_179524_a();
                    this.func_174826_a(this.func_174813_aQ().func_72317_d((double)facing.func_176743_c().func_179524_a(), 0.0, 0.0));
                    break;
                }
            }
            this.setDataMoveflg(true);
        }
    }

    private void doorClose() {
        if (this.getDataMoveflg()) {
            EnumFacing facing = this.getDir();
            if (this.getDataMirror()) {
                facing = facing.func_176734_d();
            }
            switch (facing.func_176740_k()) {
                case X: {
                    this.field_70161_v += (double)facing.func_176743_c().func_179524_a();
                    this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, 0.0, (double)facing.func_176743_c().func_179524_a()));
                    break;
                }
                case Z: {
                    this.field_70165_t -= (double)facing.func_176743_c().func_179524_a();
                    this.func_174826_a(this.func_174813_aQ().func_72317_d((double)(-facing.func_176743_c().func_179524_a()), 0.0, 0.0));
                    break;
                }
            }
            this.setDataMoveflg(false);
        }
    }

    private boolean isOpendir(Entity entity) {
        if (entity.func_174811_aO() != this.getDir() && entity.func_174811_aO() != this.getDir().func_176734_d()) {
            return false;
        }
        return this.func_70032_d(entity) < 1.25f;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DIRECTION, (Object)0);
        this.field_70180_af.func_187214_a(ISMIRROR, (Object)0);
        this.field_70180_af.func_187214_a(ISMOVE, (Object)0);
        this.field_70180_af.func_187214_a(ISSTOP, (Object)0);
        this.field_70180_af.func_187214_a(MOVEDIR, (Object)0);
        this.field_70180_af.func_187214_a(DOORID, (Object)0);
    }

    private EnumFacing getDataDir() {
        return EnumFacing.func_176731_b((int)((Byte)this.field_70180_af.func_187225_a(DIRECTION)).byteValue());
    }

    private boolean getDataMirror() {
        return (Byte)this.field_70180_af.func_187225_a(ISMIRROR) == 1;
    }

    private boolean getDataMoveflg() {
        return (Byte)this.field_70180_af.func_187225_a(ISMOVE) == 1;
    }

    private byte getDataMovedir() {
        return (Byte)this.field_70180_af.func_187225_a(MOVEDIR);
    }

    private boolean getDataIsStop() {
        return (Byte)this.field_70180_af.func_187225_a(ISSTOP) == 1;
    }

    private byte getDataDoorId() {
        return (Byte)this.field_70180_af.func_187225_a(DOORID);
    }

    public SlideDoor setDataDir(byte b) {
        this.field_70180_af.func_187227_b(DIRECTION, (Object)b);
        return this;
    }

    public void setDataMirror(boolean flg) {
        this.field_70180_af.func_187227_b(ISMIRROR, (Object)(flg ? (byte)1 : 0));
    }

    public void setDataMoveflg(boolean flg) {
        this.field_70180_af.func_187227_b(ISMOVE, (Object)(flg ? (byte)1 : 0));
    }

    public void setDataMovedir(byte dir) {
        this.field_70180_af.func_187227_b(MOVEDIR, (Object)dir);
    }

    public SlideDoor setDataisStop(boolean flg) {
        this.field_70180_af.func_187227_b(ISSTOP, (Object)(flg ? (byte)1 : 0));
        return this;
    }

    public SlideDoor setDataDoorId(int id) {
        this.field_70180_af.func_187227_b(DOORID, (Object)((byte)id));
        return this;
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean isBlend() {
        return this.getEnumSlideDoor(this.getDataDoorId()).isBlend();
    }

    private EnumSlideDoor getEnumSlideDoor(int id) {
        if (id < tex.length) {
            return tex[id];
        }
        this.setDataDoorId(EnumSlideDoor.HUSUMA.getId());
        return EnumSlideDoor.HUSUMA;
    }
}

