/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.entity.arrow;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import ruby.bamboo.api.BambooItems;
import ruby.bamboo.entity.arrow.BaseArrow;
import ruby.bamboo.item.arrow.AntiArrow;

public class EntityAntiArrow
extends BaseArrow {
    private static final DataParameter<Byte> TYPE = EntityDataManager.func_187226_a(EntityAntiArrow.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityAntiArrow(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityAntiArrow(World worldIn, EntityLivingBase shooter, float velocity) {
        super(worldIn, shooter, velocity);
    }

    public EntityAntiArrow(World worldIn) {
        super(worldIn);
    }

    public EntityAntiArrow(World worldIn, EntityLivingBase shooter, float velocity, ItemStack is) {
        super(worldIn, shooter, velocity);
        this.setArrowType(AntiArrow.AntiType.getType(is.func_77952_i()));
    }

    public void setArrowType(AntiArrow.AntiType type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type.getID());
    }

    public AntiArrow.AntiType getArrowType() {
        return AntiArrow.AntiType.getType(((Byte)this.field_70180_af.func_187225_a(TYPE)).intValue());
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
    }

    @Override
    public int getArrowDamage(Entity entity) {
        int damage = super.getArrowDamage(entity);
        for (Class<? extends Entity> clazz : this.getArrowType().getEntity()) {
            if (!clazz.isInstance(entity)) continue;
            damage = (int)((double)damage * (1.0 + 1.5 / (double)this.getArrowType().getEntity().length));
            break;
        }
        return damage;
    }

    @Override
    public DamageSource getDamageSource(EntityArrow arrow, Entity entity) {
        if (this.getArrowType() != AntiArrow.AntiType.ENDERMAN) {
            return DamageSource.func_76353_a((EntityArrow)arrow, (Entity)entity);
        }
        return new EntityDamageSource("antiEnder", entity);
    }

    @Override
    public boolean onEntityDamaged(Entity entityHit) {
        if (this.getArrowType() != AntiArrow.AntiType.ENDERMAN) {
            return true;
        }
        this.func_70106_y();
        return false;
    }

    @Override
    public void motionUpdate(float xyzVariation, float yDecrease) {
        if (this.getArrowType() == AntiArrow.AntiType.WATER) {
            xyzVariation = 0.99f;
        }
        this.field_70159_w *= (double)xyzVariation;
        this.field_70181_x *= (double)xyzVariation;
        this.field_70179_y *= (double)xyzVariation;
        this.field_70181_x -= (double)yDecrease * 0.5;
    }

    @Override
    public void spawnCritParticle() {
        for (int k = 0; k < 4; ++k) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT_MAGIC, this.field_70165_t + this.field_70159_w * (double)k / 4.0, this.field_70163_u + this.field_70181_x * (double)k / 4.0, this.field_70161_v + this.field_70179_y * (double)k / 4.0, 0.0, -0.025, 0.0, new int[0]);
        }
    }

    @Override
    public ItemStack getItemArrow() {
        return new ItemStack(BambooItems.ANTI_ARROW, 1, (int)this.getArrowType().getID());
    }

    @Override
    public NBTTagCompound writeCustomNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("id", this.getArrowType().getID());
        return nbt;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("id")) {
            this.setArrowType(AntiArrow.AntiType.getType(nbt.func_74771_c("id")));
        }
    }
}

