/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.entity.arrow;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import ruby.bamboo.api.BambooItems;
import ruby.bamboo.entity.arrow.BaseArrow;
import ruby.bamboo.entity.arrow.TimerBomb;

public class EntityExplodeArrow
extends BaseArrow {
    public EntityExplodeArrow(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityExplodeArrow(World worldIn, EntityLivingBase shooter, float velocity) {
        super(worldIn, shooter, velocity);
    }

    public EntityExplodeArrow(World worldIn) {
        super(worldIn);
    }

    @Override
    public void onEntityHited(Entity entityHit, float power) {
        if (entityHit instanceof EntityLivingBase) {
            TimerBomb bomb = new TimerBomb(this.field_70170_p);
            if (!this.field_70170_p.field_72995_K) {
                bomb.setParentEntity(entityHit);
                bomb.setTimer((int)(200.0f * power));
                this.field_70170_p.func_72838_d((Entity)bomb);
            }
        }
    }

    @Override
    public int getArrowDamage(Entity entity) {
        return 1;
    }

    @Override
    public void spawnCritParticle() {
        for (int k = 0; k < 4; ++k) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + this.field_70159_w * (double)k / 4.0, this.field_70163_u + this.field_70181_x * (double)k / 4.0, this.field_70161_v + this.field_70179_y * (double)k / 4.0, 0.0, -0.025, 0.0, new int[0]);
        }
    }

    @Override
    public ItemStack getItemArrow() {
        return new ItemStack(BambooItems.EXPLODE_ARROW, 1, 0);
    }
}

