/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ruby.bamboo.api.BambooItems;
import ruby.bamboo.core.PacketDispatcher;
import ruby.bamboo.core.client.KeyBindFactory;
import ruby.bamboo.core.init.BambooData;
import ruby.bamboo.core.init.EnumCreateTab;
import ruby.bamboo.entity.arrow.BaseArrow;
import ruby.bamboo.item.arrow.IBambooArrow;
import ruby.bamboo.packet.MessageBambooUtil;
import ruby.bamboo.util.ItemStackHelper;

@BambooData.BambooItem(createiveTabs=EnumCreateTab.TAB_BAMBOO)
public class BambooBow
extends ItemBow
implements KeyBindFactory.IItemUtilKeylistener,
MessageBambooUtil.IMessagelistener {
    public static final String TAG_AMMO = "ammo";
    public static final String AMMO_SLOT = "slot";

    public BambooBow() {
        this.func_77656_e(400);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                if (entityIn instanceof EntityPlayer) {
                    InventoryPlayer inv = ((EntityPlayer)entityIn).field_71071_by;
                    ItemStack itemstack = entityIn.func_184607_cu();
                    int chargeFrame = stack.func_77988_m() - entityIn.func_184605_cv();
                    BambooBow bowIn = (BambooBow)BambooItems.BAMBOO_BOW;
                    float f = (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f;
                    if (BambooBow.this.hasInventoryBambooArrow((IInventory)inv)) {
                        IBambooArrow arrow = (IBambooArrow)inv.func_70301_a(BambooBow.this.getSelectedInventorySlotContainItem((IInventory)inv, stack)).func_77973_b();
                        f = arrow.getBowModel(chargeFrame);
                    }
                    return itemstack != null && itemstack.func_77973_b() == BambooItems.BAMBOO_BOW ? f : 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return itemstack != null && itemstack.func_77973_b() == BambooItems.BAMBOO_BOW ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            boolean isNoResource;
            EntityPlayer player = (EntityPlayer)entityLiving;
            boolean flag = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            int chargeFrame = this.func_77626_a(stack) - timeLeft;
            if ((chargeFrame = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)((EntityPlayer)entityLiving), (int)chargeFrame, (stack != null || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            InventoryPlayer inv = player.field_71071_by;
            boolean bl = isNoResource = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            if (this.hasInventoryBambooArrow((IInventory)inv)) {
                float power = (float)chargeFrame / 10.0f;
                if ((double)(power = (power * power + power * 2.0f) / 3.0f) < 0.1) {
                    return;
                }
                if (power > 1.0f) {
                    power = 1.0f;
                }
                int slotNum = this.getSelectedInventorySlotContainItem((IInventory)inv, stack);
                ItemStack arrowStack = inv.func_70301_a(slotNum);
                IBambooArrow arrow = (IBambooArrow)arrowStack.func_77973_b();
                BaseArrow entityArrow = arrow.createArrowIn(worldIn, stack, arrowStack, power, chargeFrame, player);
                if (!worldIn.field_72995_K) {
                    worldIn.func_72838_d((Entity)entityArrow);
                }
                if (!arrow.isNoResources(player, stack)) {
                    ItemStackHelper.decrStackSize((IInventory)player.field_71071_by, arrowStack, 1);
                } else {
                    entityArrow.setNoPick();
                    entityArrow.setMaxAge(60);
                }
                worldIn.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + power * 0.5f);
            }
            if (!isNoResource) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        InventoryPlayer inv = player.field_71071_by;
        boolean flag = this.hasInventoryBambooArrow((IInventory)inv);
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemStack, (World)world, (EntityPlayer)player, (EnumHand)hand, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        if (player.field_71075_bZ.field_75098_d || this.hasInventoryBambooArrow((IInventory)inv) || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)itemStack) > 0) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
    }

    public int func_77619_b() {
        return 1;
    }

    private boolean hasInventoryBambooArrow(IInventory inv) {
        return this.getInventorySlotContainItem(inv) >= 0;
    }

    private int getInventorySlotContainItem(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null || !(inv.func_70301_a(i).func_77973_b() instanceof IBambooArrow)) continue;
            return i;
        }
        return -1;
    }

    private int getSelectedInventorySlotContainItem(IInventory inv, ItemStack stack) {
        byte arrowSlotNum;
        ItemStackHelper.HashedStack[] arrows = this.getArrowTypes(inv).toArray(new ItemStackHelper.HashedStack[0]);
        if (arrows.length > (arrowSlotNum = this.getArrowSlot(stack))) {
            return ItemStackHelper.getSlotNum(inv, arrows[arrowSlotNum].getItemStack());
        }
        return 0;
    }

    private Map<ItemStackHelper.HashedStack, Integer> getArrowMap(InventoryPlayer inv) {
        LinkedHashMap<ItemStackHelper.HashedStack, Integer> map = new LinkedHashMap<ItemStackHelper.HashedStack, Integer>();
        ArrayList invAndOffHand = Lists.newArrayList((Object[])inv.field_70462_a);
        invAndOffHand.addAll(Arrays.asList(inv.field_184439_c));
        for (ItemStack stack : invAndOffHand) {
            if (stack == null || !(stack.func_77973_b() instanceof IBambooArrow)) continue;
            Item item = stack.func_77973_b();
            int size = stack.field_77994_a;
            ItemStackHelper.HashedStack hashStack = new ItemStackHelper.HashedStack(stack);
            if (map.containsKey(hashStack)) {
                size += ((Integer)map.get(hashStack)).intValue();
            }
            map.put(hashStack, size);
        }
        return map;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderTip(RenderGameOverlayEvent.Text e) {
        EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
        ItemStack handStack = this.findBow((EntityPlayer)player);
        if (handStack != null && handStack.func_77973_b() == this) {
            Map<ItemStackHelper.HashedStack, Integer> map = this.getArrowMap(player.field_71071_by);
            GuiIngame gui = FMLClientHandler.instance().getClient().field_71456_v;
            int maxWidth = 0;
            for (ItemStackHelper.HashedStack stack : map.keySet()) {
                int width = gui.func_175179_f().func_78256_a(stack.item.func_77653_i(stack.getItemStack()) + ":" + map.get(stack));
                if (width <= maxWidth) continue;
                maxWidth = width;
            }
            byte slotPos = this.getArrowSlot(handStack);
            byte nuwPos = 0;
            for (ItemStackHelper.HashedStack stack : map.keySet()) {
                byte by = nuwPos;
                nuwPos = (byte)(nuwPos + 1);
                this.draw(e, maxWidth, stack.item.func_77653_i(stack.getItemStack()) + ":" + map.get(stack), slotPos == by ? 0xE06060 : 0xE0E0E0);
            }
        }
    }

    private void draw(RenderGameOverlayEvent.Text e, int startLeftpos, String msg, int color) {
        GuiIngame gui = FMLClientHandler.instance().getClient().field_71456_v;
        int top = 2 + gui.func_175179_f().field_78288_b * e.getLeft().size();
        int w = gui.func_175179_f().func_78256_a(msg);
        int left = e.getResolution().func_78326_a() - 2 - startLeftpos;
        Gui.func_73734_a((int)1, (int)(top - 1), (int)(startLeftpos + 1), (int)(top + gui.func_175179_f().field_78288_b - 1), (int)-1873784752);
        gui.func_175179_f().func_78276_b(msg, 1, top, color);
        e.getLeft().add(null);
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (par5 && par3Entity instanceof EntityPlayer && !par2World.field_72995_K) {
            EntityPlayer player = (EntityPlayer)par3Entity;
            byte types = (byte)this.getArrowTypes((IInventory)player.field_71071_by).size();
            if (this.getArrowSlot(par1ItemStack) >= types && types > 0) {
                types = (byte)(types - 1);
                par1ItemStack.func_179543_a(TAG_AMMO, true).func_74774_a(AMMO_SLOT, types);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void exec(KeyBinding key) {
        EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
        if (key.func_151468_f()) {
            ItemStack is = this.findBow((EntityPlayer)player);
            byte slotNum = this.getArrowSlot(is);
            int invArrowTypes = this.getArrowTypes((IInventory)player.field_71071_by).size();
            if ((slotNum = (byte)(slotNum + 1)) >= invArrowTypes) {
                slotNum = 0;
            }
            PacketDispatcher.sendToServer(new MessageBambooUtil(slotNum));
        }
    }

    @Override
    public void call(EntityPlayer playerEntity, ItemStack is, byte data) {
        is.func_179543_a(TAG_AMMO, true).func_74774_a(AMMO_SLOT, data);
    }

    public byte getArrowSlot(ItemStack is) {
        if (!is.func_77942_o()) {
            is.func_179543_a(TAG_AMMO, true).func_74774_a(AMMO_SLOT, (byte)0);
        }
        return is.func_179543_a(TAG_AMMO, true).func_74771_c(AMMO_SLOT);
    }

    public Set<ItemStackHelper.HashedStack> getArrowTypes(IInventory inv) {
        LinkedHashSet<ItemStackHelper.HashedStack> stackSet = new LinkedHashSet<ItemStackHelper.HashedStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof IBambooArrow)) continue;
            ItemStackHelper.HashedStack hashStack = new ItemStackHelper.HashedStack(stack);
            stackSet.add(hashStack);
        }
        return stackSet;
    }

    public boolean func_77651_p() {
        return true;
    }

    private ItemStack findBow(EntityPlayer player) {
        if (this.isBow(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isBow(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        return null;
    }

    private boolean isBow(@Nullable ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof BambooBow;
    }
}

