/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.item;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ruby.bamboo.core.init.BambooData;
import ruby.bamboo.core.init.EnumCreateTab;
import ruby.bamboo.texture.IMultiTextuerItem;

@BambooData.BambooItem(createiveTabs=EnumCreateTab.TAB_BAMBOO)
public class BambooFood
extends ItemFood
implements IMultiTextuerItem,
EnumCreateTab.ICreativeSoatName {
    public BambooFood() {
        super(0, false);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public int func_77626_a(ItemStack stack) {
        return Food.getState((int)stack.func_77952_i()).duration;
    }

    public int func_150905_g(ItemStack stack) {
        return Food.getState((int)stack.func_77952_i()).heal;
    }

    public float func_150906_h(ItemStack stack) {
        return Food.getState((int)stack.func_77952_i()).sMod;
    }

    @Override
    public Map<Integer, String> getTexName() {
        return Arrays.stream(Food.values()).collect(Collectors.toMap(key -> key.id, val -> val.texPath));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        subItems.addAll(Arrays.stream(Food.values()).map(e -> new ItemStack(itemIn, 1, e.id)).collect(Collectors.toList()));
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + stack.func_77952_i();
    }

    @Override
    public String getSortName(ItemStack is) {
        return "zzz" + this.func_77667_c(is);
    }

    static enum Food {
        RICE(0, 3, 1.5f, 32, "mugimesi"),
        BEEFRICE(1, 10, 5.0f, 32, "gyumesi"),
        BUTAMESI(2, 12, 6.0f, 48, "butamesi"),
        KINOKOMESI(3, 6, 3.0f, 32, "kinokomesi"),
        BUTAKUSI(4, 10, 5.0f, 16, "butakusi"),
        GYUKUSI(5, 8, 4.0f, 8, "gyukusi"),
        TAKEMESI(6, 5, 5.0f, 32, "takemesi"),
        TAMAKAKE(7, 5, 2.0f, 24, "tamakake"),
        OYAKO(8, 12, 6.0f, 64, "oyako"),
        TEKKA(9, 7, 3.5f, 36, "tekka"),
        TORIKUSI(10, 9, 3.0f, 12, "torikusi"),
        UMEONI(11, 4, 3.0f, 18, "umeoni"),
        SAKEONI(12, 7, 5.0f, 24, "sakeoni"),
        TUNAONI(13, 8, 7.0f, 24, "tunaoni"),
        KINOONI(14, 5, 2.6f, 24, "kinooni"),
        TAKEONI(15, 6, 6.0f, 24, "takeoni"),
        WAKAMEONI(16, 6, 5.0f, 24, "wakameoni"),
        DANANKO(17, 7, 4.0f, 16, "dananko"),
        DANKINAKO(18, 7, 4.0f, 16, "dankinako"),
        DANMITARASHI(19, 7, 4.0f, 16, "danmitarashi"),
        DANSANSYOKU(20, 7, 6.0f, 16, "dansansyoku"),
        DANZUNDA(21, 7, 5.0f, 16, "danzunda"),
        MOCHI(22, 6, 3.0f, 72, "mochi"),
        COOKEDMOCHI(23, 6, 5.0f, 36, "cookedmochi"),
        OHAANKO(24, 7, 4.0f, 36, "ohaanko"),
        OHAKINAKO(25, 7, 4.0f, 36, "ohakinako"),
        OHAZUNDA(26, 7, 4.0f, 36, "ohazunda"),
        NATTO(27, 2, 1.0f, 16, "natto"),
        NATTOMESHI(28, 5, 3.0f, 16, "nattomeshi"),
        TAMANATTOMESHI(29, 7, 6.0f, 16, "tamanattomeshi"),
        SAKURAMOCHI(30, 7, 6.0f, 36, "sakuramochi"),
        TAMAGYUMESHI(31, 11, 6.0f, 24, "tamagyumeshi"),
        KATSUDON(32, 11, 6.0f, 24, "katsudon"),
        SEKIHAN(33, 5, 4.0f, 36, "sekihan"),
        ONISEKIHAN(34, 7, 6.0f, 28, "onisekihan"),
        TOFU(35, 1, 0.5f, 10, "tofu"),
        AGEDASHI(36, 3, 2.0f, 16, "agedashi"),
        MEN(37, 1, 0.5f, 32, "men"),
        UDON(38, 10, 3.0f, 64, "udon"),
        SOBA(39, 12, 3.0f, 64, "soba"),
        RAMEN(40, 18, 9.0f, 128, "ramen"),
        PIZZA(41, 10, 5.0f, 64, "pizza"),
        KAISENOYAKO(42, 8, 4.0f, 36, "kaisenoyako");

        static Map<Integer, Food> idToStateMap;
        int id;
        int heal;
        float sMod;
        int duration;
        String texPath;

        private Food(int id, int heal, float sMod, int duration, String texName) {
            this.id = id;
            this.heal = heal;
            this.sMod = sMod;
            this.duration = duration;
            this.texPath = "bamboomod:items/" + texName;
        }

        public static Food getState(int id) {
            return idToStateMap.containsKey(id) ? idToStateMap.get(id) : RICE;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            idToStateMap = ImmutableMap.copyOf(Arrays.stream(Food.values()).collect(Collectors.toMap(key -> key.id, val -> val)));
        }
    }
}

