/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.item;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ruby.bamboo.enchant.Curse;
import ruby.bamboo.enchant.EnchantBase;
import ruby.bamboo.enchant.IBambooEnchantable;
import ruby.bamboo.enchant.SpecialEnchant;

public class BambooPickaxe
extends ItemPickaxe
implements IBambooEnchantable {
    public BambooPickaxe() {
        super(Item.ToolMaterial.DIAMOND);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (!attacker.func_130014_f_().field_72995_K) {
            this.addExpChance(stack, target);
        }
        SpecialEnchant.onAttackEntity(stack, target, attacker);
        return true;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return super.getToolClasses(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return Short.MAX_VALUE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        String name = stack.func_82833_r();
        tooltip.set(0, tooltip.get(0).replaceFirst(Pattern.quote(name), this.getPrefix(stack) + name + this.getSuffix(stack)));
        tooltip.addAll(IBambooEnchantable.getSpenchList(stack).stream().map(e -> {
            EnchantBase base = SpecialEnchant.getEnchantmentById(e.func_74765_d("id"));
            StringBuilder stb = new StringBuilder();
            boolean isCurse = base instanceof Curse;
            stb.append("\u00a7").append(isCurse ? "4" : "b").append("\u00a7l");
            stb.append(base.getName(stack, EnchantBase.getSubID(e.func_74765_d("id"))));
            stb.append(" ").append(!isCurse ? "\u00a7w" : "");
            stb.append(base.getMaxLevel() > 1 ? IBambooEnchantable.getDisplayEnchantStrength(e.func_74765_d("lvl")) : "");
            return stb.toString();
        }).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onToolTip(ItemTooltipEvent e) {
        if (e.getItemStack().func_77973_b() == this) {
            String[] ignore = new String[]{"Power"};
            e.getToolTip().removeIf(str -> Arrays.stream(ignore).anyMatch(ignoreStr -> str.indexOf((String)ignoreStr) != -1));
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K && entityIn instanceof EntityLivingBase) {
            SpecialEnchant.onUpdate(stack, (EntityLivingBase)entityIn, itemSlot, isSelected);
        }
    }

    public int getItemEnchantability(ItemStack stack) {
        return 0;
    }

    public String getHighlightTip(ItemStack stack, String displayName) {
        return this.getPrefix(stack) + super.getHighlightTip(stack, displayName) + this.getSuffix(stack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        IBambooEnchantable.createNBT(stack);
        return null;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0f - IBambooEnchantable.getExpP(stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return 3;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }
}

